package com.tll.task.rpc.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 表单详情查询请求参数
 *
 * @author Jxinx
 * @date 2024-10-30
 */
@Data
@ApiModel(description = "表单详情查询请求参数")
public class FormDetailQueryRpcDTO implements Serializable {

    private static final long serialVersionUID = -4272547965048531161L;

    /**
     * 记录id或表单id
     */
    @NotBlank(message = "记录id或表单id不能为空")
    @ApiModelProperty(value = "记录id或表单id")
    private String id;

    /**
     * 任务ID（用于联动过滤接口）
     */
    @ApiModelProperty(value = "任务ID（用于联动过滤接口，可选）")
    private Long taskId;

    /**
     * 任务类型（用于联动过滤接口）：1-门店任务，2-员工任务
     */
    @ApiModelProperty(value = "任务类型：1-门店任务，2-员工任务（用于联动过滤接口，可选）")
    private Integer taskType;

}
