package com.tll.task.rpc.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * 表单状态更新请求参数
 *
 * @author Jxinx
 * @since 2025-06-27
 */
@Data
@ApiModel(description = "表单状态更新请求参数")
public class FormStatusUpdateRpcDTO implements Serializable {

    private static final long serialVersionUID = -1821335291812850768L;

    /**
     * 表单id集合
     */
    @NotEmpty(message = "表单id集合不能为空")
    @ApiModelProperty(value = "表单id集合")
    private List<String> formIds;
}
