package com.tll.task.rpc.dto;

import com.tll.task.constant.DemoCategoryEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * demo新增数据.
 *
 * @author Kaiser（wang shao）
 * @date 2023/4/9
 */
@Data
public class YstDemoInsertDTO implements Serializable {
    private static final long serialVersionUID = 3135470054581477543L;

    /**
     * 编码
     */
    @NotBlank(message = "编码不能为空")
    @Size(min = 1, max = 20, message = "编码的长度限制是1~20")
    private String code;

    /**
     * 名称
     */
    @NotBlank(message = "名称不能为空")
    @Size(min = 1, max = 40, message = "名称的长度限制是1~40")
    private String name;

    /**
     * 是否启用，默认是
     */
    @ApiModelProperty(value = "是否启用，默认是", position = 4)
    private Boolean enabled;

    /**
     * 类别
     */
    @NotNull(message = "类别不能为空")
    private DemoCategoryEnum category;

    /**
     * 描述
     */
    @ApiModelProperty(value = "描述")
    private String description;
}
