package com.tll.task.rpc.dto.backlogCenter;

import com.tll.task.rpc.vo.backlogCenter.EmployeePageRespRpcVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 子任务数据统计
 *
 * @author Kaiser（qishendeng）
 * @date 2024/10/29
 */
@Data
@ApiModel(description = "子任务数据统计")
public class MainListRpcDTO implements Serializable {

    @ApiModelProperty(value = "用户id(当前登录人id)")
    private Long userId;
    
    @ApiModelProperty("角色(岗位名称)")
    private String role;

    @ApiModelProperty("人员信息")
    private List<EmployeePageRespRpcVO> userList;

    @ApiModelProperty("子任务状态(自测字段不用传)")
    private List<Integer> taskState;

    @ApiModelProperty("是否是默认 1：默认 2：正常")
    private int isDefault;

}
