package com.tll.task.rpc.vo;

import com.alibaba.excel.annotation.format.DateTimeFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 员工任务列表
 *
 * @author Jxinx
 * @date 2024-12-20
 */
@Data
@ApiModel(description = "员工任务-分页数据展示")
public class EmployeeTaskPageRpcVO implements Serializable {

    @ApiModelProperty(value = "员工任务主键Id")
    public Long id;

    @ApiModelProperty(value = "任务Id")
    public String taskId;

    @ApiModelProperty(value = "员工任务ID")
    public String employTaskNumber;

    @ApiModelProperty(value = "任务内容 1:指定表单 2:指定公告")
    public String taskNote;

    @ApiModelProperty(value = "表单或公告Id")
    public Long taskNoteNumber;

    @ApiModelProperty(value = "任务名称")
    public String taskName;

    @ApiModelProperty(value = "任务状态：0-待提交，1-已完成，2-已回收，3-已过期，4-整改中，5-待审核，6-审核中，7-待整改，8-已失效")
    public Integer taskState;

    @ApiModelProperty(value = "任务所属部门id")
    public Long taskDepartmentId;

    @ApiModelProperty(value = "任务所属部门")
    public String taskDepartment;

    @ApiModelProperty(value = "是否催办  0：未催办  1:已催办")
    public Integer isUrge;

    @ApiModelProperty(value = "任务创建人")
    public String createBy;

    @ApiModelProperty(value = "计划执行人员工id")
    public Long planExecutorId;

    @ApiModelProperty(value = "计划执行人")
    public String planExecutor;

    @ApiModelProperty(value = "实际执行人")
    public String realExecutor;

    @ApiModelProperty(value = "实际执行人岗位")
    public String realExecutorRole;

    @ApiModelProperty(value = "执行人所属部门id")
    public Long realExecutorDepartmentId;

    @ApiModelProperty(value = "执行人所属部门")
    public String realExecutorDepartment;

    @ApiModelProperty(value = "任务开始时间")
    public LocalDateTime taskPlanStartTime;

    @ApiModelProperty(value = "任务结束时间")
    @DateTimeFormat("yyyy-MM-dd HH:mm:ss")
    public LocalDateTime taskPlanEndTime;

    @ApiModelProperty(value = "实际执行时间")
    public LocalDateTime endTime;
}
