package com.tll.task.rpc.vo;

import com.tll.task.rpc.vo.backlogCenter.AreaTreeRespRpcVo;
import com.tll.task.rpc.vo.backlogCenter.MainSubtaskDataStatisticsRpcVO;
import com.tll.task.rpc.vo.backlogCenter.StaffListRpcVO;
import com.tll.task.rpc.vo.backlogCenter.SubtaskDataStatisticsRpcVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 统一返回.
 *
 * @author Kaiser（qishendeng）
 * @date 2024/10/29
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "统一返回")
public class UnifiedReturnRpcVO implements Serializable {
    private static final long serialVersionUID = 5193801339140708647L;

    /**
     * 返回值
     */
    @ApiModelProperty(value = "returnValue")
    private String returnValue;
    
    
    /**
     * id
     */
    @ApiModelProperty(value = "id")
    private Long id;
    
    /**
     * 获取省市区组织结构树
     */
    @ApiModelProperty(value = "获取省市区组织结构树")
    private List<AreaTreeRespRpcVo> list;
    
    /**
     * 统计页面url
     */
    @ApiModelProperty(value = "统计页面url")
    private String url;

    /**
     * 主任务数据统计
     */
    @ApiModelProperty("主任务数据统计")
    private List<MainSubtaskDataStatisticsRpcVO> mainList;

    /**
     * 子任务数据统计
     */
    @ApiModelProperty("子任务数据统计")
    private List<SubtaskDataStatisticsRpcVO> subList;

    /**
     * 获取权限下人员信息
     */
    @ApiModelProperty(value = "获取权限下人员信息")
    private List<StaffListRpcVO> staffListVOS;
}
