package com.tll.task.rpc.vo.backlogCenter;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 员工子任务数据统计详情
 *
 * @author Jxinx
 * @since 2025-04-18
 */
@Data
@ApiModel(description = "子任务数据统计详情")
public class EmployeeTaskStatInfoRpcVO implements Serializable {

    private static final long serialVersionUID = 8070544596229889653L;

    @ApiModelProperty("数据类型：1-员工，2-部门")
    private Integer dataType;

    @ApiModelProperty("部门id")
    private Long orgId;

    @ApiModelProperty("部门名称")
    private String orgName;

    @ApiModelProperty("员工id")
    private Long userId;

    @ApiModelProperty("员工名称")
    private String personnelName;

    @ApiModelProperty("全部数量")
    private Integer totalCount=0;

    @ApiModelProperty("待处理数量")
    private Integer pendingCount=0;

    @ApiModelProperty("已完成数量")
    private Integer completedCount=0;

    @ApiModelProperty("完成率")
    private String completionRate="0.00";
    
}
