package com.tll.task.rpc.vo.backlogCenter;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 子任务详情-员工.
 *
 * @author Kaiser（qishendeng）
 * @date 2024/10/29
 */
@Data
@ApiModel(description = "子任务详情-员工")
public class InfoEmployeeSubtaskRpcVO implements Serializable{
    
    //主任务信息
    @ApiModelProperty("主任务信息")
    private MainTaskListRpcVO mainTaskListVO;
    //进度记录
    @ApiModelProperty("进度记录")
    private List<OperationLogRpcVO> logList;
    //任务详情数据
    @ApiModelProperty("任务详情数据")
    private EmployeeTasksDetailsRpcVO details;

    @ApiModelProperty("是否催办,0：未催办  1:已催办")
    private Integer isUrge;

    @ApiModelProperty("类型[0:执行者 1:关注者 2:接收汇报者 3:创建人]")
    private Integer type;

    @ApiModelProperty("是否可操作[0:不可操作 1:可操作]")
    private Integer isOperation;

    @ApiModelProperty("任务协同人角色")
    private List<String> cotaskingRoleList;

    // 任务关联链接（taskNote=3时）
    @ApiModelProperty("指定链接内容")
    private String linkContent;

    // 任务关联页面（taskNote=7时）
    @ApiModelProperty("页面名称")
    private String pageName;
    @ApiModelProperty("页面链接")
    private String pagePath;

    // 默认详情页内容（taskNote=8时）
    @ApiModelProperty("默认详情页内容")
    private String defaultPageContent;
}
