package com.tll.task.rpc.vo.backlogCenter;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 操作记录详情
 *
 * @author Jxinx
 * @date 2024-09-20
 */
@Data
public class OperationLogRpcVO implements Serializable {

    @ApiModelProperty("主键id")
    Long id;

    @ApiModelProperty("任务唯一标识符")
    private String employeeTaskNumber;

    @ApiModelProperty("任务类型（1: 门店任务，2: 员工任务）")
    private Integer taskType;

    @ApiModelProperty("日志记录时间")
    private LocalDateTime logTime;

    @ApiModelProperty("操作人姓名")
    private String operator;

    @ApiModelProperty("操作类型：0-创建，1-提交，2-审核，3-驳回，4-阅读，5-撤销，6-失效，7-催办，8-移交，9-过期，10-草稿")
    private Integer operationType;

    @ApiModelProperty("任务名称")
    private String taskName;


    @ApiModelProperty("审核状态")
    private Integer auditStatus;

    @ApiModelProperty("驳回原因（若无则为 NULL）")
    private String rejectionReason;

    @ApiModelProperty("备注（若无则为 NULL）")
    private String remark;

    @ApiModelProperty("存储完整的表单内容，JSON 格式")
    private String dataRemark;

    @ApiModelProperty("格式化后的日志文本内容")
    private String formattedLog;

    @ApiModelProperty("历史任务报告")
    private EmployeeTasksDetailsRpcVO employeeTasksDetailsRpcVO;

}
