package com.tll.task.rpc.vo.backlogCenter;

import com.tll.task.rpc.dto.backlogCenter.StoreInfoRpcDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * Author: daidemin
 * Date: 2024/9/3 10:02
 */
@Data
@ApiModel(description = "门店任务列表C端")
public class StoreTaskListRpcVO implements Serializable{
    private static final long serialVersionUID = -1L;

    @ApiModelProperty(value = "记录唯一ID")
    private Long id;

    @ApiModelProperty("主任务id")
    private String taskId;

    @ApiModelProperty("任务内容 1:指定表单 2:指定公告 3：链接 4:管理费用 5:违约金")
    private String taskNote;

    @ApiModelProperty("任务关联的表单/公告ID/单据ID")
    private String taskNoteId;

    @ApiModelProperty(value = "记录创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "门店任务Id")
    private String storeTaskId;
    
    @ApiModelProperty("门店编码")
    private String storeCoding;
    
    @ApiModelProperty("门店名称")
    private String storeName;
    
    @ApiModelProperty(value = "任务名称")
    private String taskName;
    
    @ApiModelProperty(value = "任务备注说明")
    private String taskRemark;
    
    @ApiModelProperty(value = "门店任务状态  0：待提交   1：已完成   2：已回收  3：已过期  4：整改中 5：待审核   6：审核中   7：待整改 8：已失效 9：存草稿")
    private Integer taskState;

    @ApiModelProperty("任务形式 1:任务型 2:通知型 3:收集型")
    private Integer taskType;

    @ApiModelProperty("任务的提交状态 1：草稿  2：提交")
    private Integer submitStatus;
    
    @ApiModelProperty(value = "查阅状态  0：未查阅  1：已查阅")
    private Integer isRead;
    @ApiModelProperty(value = "计划执行人")
    private String planExecutor;
    @ApiModelProperty(value = "任务创建人")
    private String creator;
    @ApiModelProperty(value = "任务开始时间")
    private LocalDateTime beginTime;
    @ApiModelProperty(value = "任务结束时间")
    private LocalDateTime endTime;
    @ApiModelProperty(value = "撤销状态 0：未撤销 1：已撤销")
    private Integer isBack;
    @ApiModelProperty(value = "催办状态 0：未催办 1：已催办")
    private Integer urgeState;
    //催办时间
    @ApiModelProperty("催办时间")
    private LocalDateTime urgeTime;
    
    //门店信息
    @ApiModelProperty("门店信息")
    private StoreInfoRpcDTO storeInfoDTO;
    
    //主任务信息
    @ApiModelProperty("任务开始时间")
    private LocalDateTime taskStartTime;

    @ApiModelProperty("任务结束时间")
    private LocalDateTime taskEndTime;

    @ApiModelProperty("创建人")
    private String taskInfoCreator;

    @ApiModelProperty("任务类型 1:门店任务 2:员工任务")
    private String taskInfoType;

    @ApiModelProperty("任务形式 1:任务型 2:通知型 3:收集型")
    private String taskInfoForm;

}
