package com.tll.task.rpc.vo.employee;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 员工详情响应实体数据
 *
 * @author Jxinx
 * @date 2024-11-20
 */
@Data
@ApiModel(description = "员工详情响应实体数据")
public class EmployeeDetailRpcVO implements Serializable {

    private static final long serialVersionUID = -7391164256927128487L;

    /**
     * 员工用户ID
     */
    @ApiModelProperty(value = "员工用户ID")
    private Long userId;

    /**
     * 员工编号
     */
    @ApiModelProperty(value = "员工编号")
    private String code;

    /**
     * 姓名
     */
    @ApiModelProperty(value = "姓名")
    private String fullName;

    /**
     * 性别
     */
    @ApiModelProperty(value = "性别")
    private String genderName;

    /**
     * 职务
     */
    @ApiModelProperty(value = "职务")
    private String duty;

    /**
     * 电话
     */
    @ApiModelProperty(value = "电话")
    private String phone;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱")
    private String email;

    /**
     * 入职时间
     */
    @ApiModelProperty(value = "入职时间")
    private LocalDateTime joinTime;

    /**
     * 所在组织
     */
    @ApiModelProperty(value = "所在组织")
    private EmployeeOrgRpcVO employeeOrg;

}
