package com.tll.task.rpc.vo.employee;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 员工组织详情响应实体数据
 *
 * @author Jxinx
 * @date 2024-11-20
 */
@Data
@ApiModel(description = "员工组织详情响应实体数据")
public class EmployeeOrgRpcVO implements Serializable {

    private static final long serialVersionUID = -8249990556232724859L;

    /**
     * 组织ID
     */
    @ApiModelProperty(value = "组织ID")
    private Long orgId;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称")
    private String orgName;

    /**
     * 完整组织名称
     */
    @ApiModelProperty(value = "完整组织名称")
    private String fullOrgName;

    /**
     * 是否负责人
     */
    @ApiModelProperty(value = "是否负责人")
    private Boolean assignee;

    /**
     * 一级部门组织ID
     */
    @ApiModelProperty(value = "一级部门组织ID")
    private Long primaryOrgId;
}
