package com.tll.task.rpc.dto.employee;

import com.tll.task.rpc.dto.OptionCommitRpcDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * 员工任务提交请求实体类
 *
 * @author Jxinx
 * @date 2024-09-20
 */
@Data
public class EmployeeTaskCommitRpcDTO implements Serializable {
    
    //主任务id
    @ApiModelProperty("主任务id")
    private String taskId;

    @ApiModelProperty(value = "员工任务记录唯一ID")
    private Long id;

    @ApiModelProperty(value = "操作行为类型：1：催办 2：移交 3：审核 4：撤销 5：下载报告 6：提交")
    @NotBlank(message = "操作行为类型不能为空")
    private String actionType;

    //是否是通知类型任务
    @ApiModelProperty("任务形式 1:任务型 2:通知型 3:收集型")
    private String taskForm;
    
    //提交
    @ApiModelProperty(value = "任务内容 1:指定表单 2:指定公告")
    private String taskNote;

    @ApiModelProperty(value = "任务的提交状态 1：草稿  2：提交")
    private String submitStatus;

    @ApiModelProperty("提交内容")
    List<OptionCommitRpcDTO> optionCommitDTOS;
    
    //催办
    @ApiModelProperty("用户id")
    private String userId;

    @ApiModelProperty("用户名称")
    private String name;

    //移交
    @ApiModelProperty(value = "移交人id")
    private String assignorId;

    @ApiModelProperty(value = "受让人id")
    private String transfereeId;

    //撤销
    @ApiModelProperty(value = "撤销任务备注")
    private String cancelContext;
    
    @ApiModelProperty(value = "催办详情")
    private String actionDescribe;
}
