package com.tll.task.rpc.dto;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
/**
 * 获取可移交员工查询参数RPC DTO
 * <p>
 * 用于RPC调用获取可移交员工列表的查询参数
 * </p>
 *
 * @author XieBeiChen
 * @since 2025-01-15
 * @version 1.0.0
 */
@Data
@ApiModel(description = "获取可移交员工查询参数")
public class TaskTransferEmployeeQueryRpcDTO extends AbstractExportQueryParam {

    @NotBlank(message = "主任务ID不能为空")
    @ApiModelProperty(value = "主任务ID", required = true)
    private String taskId;

    @ApiModelProperty(value = "员工姓名搜索关键字")
    private String fullName;

    @NotNull(message = "类型区分不能为空")
    @ApiModelProperty(value = "类型区分：1-原执行人，2-新执行人", required = true)
    private Integer type;
}
