package com.tll.task.rpc.vo.backlogCenter;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Lob;
import java.io.Serializable;

/**
 * 员工任务公告详情
 *
 * @author Jxinx
 * @date 2024-09-13
 */
@Data
public class EmployeeAnnouncementsDetailRpcVO implements Serializable {

    /**
     * 记录唯一ID
     */
    @ApiModelProperty(value = "记录唯一ID")
    private Long id;

    @ApiModelProperty(value = "公告名称")
    private String name;

    @ApiModelProperty(value = "公告所属部门名称")
    private String departmentName;

    @ApiModelProperty(value = "公告所属部门编码")
    private String departmentCode;

    @ApiModelProperty("是否使用公告操作 0：无操作 1：1个按钮 2：两个按钮")
    private Integer actionType;

    @ApiModelProperty("按钮文字1")
    private String actionButton;

    @ApiModelProperty("按钮文字2")
    private String actionButtonTwo;

    @ApiModelProperty("点击按钮名称")
    private String clickButtonName;

    @Lob
    @ApiModelProperty(value = "公告内容")
    private String content;
}
