package com.tll.task.rpc.vo.backlogCenter;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 员工任务列表C端
 *
 * @author gcc
 * @date 2024-09-07 16:18:39
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "员工任务列表C端")
public class EmployeeTaskListRpcVO implements Serializable {

    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty(value = "记录唯一ID")
    private Long id;
    
    @ApiModelProperty(value = "记录创建时间")
    private LocalDateTime createTime;
    
    @ApiModelProperty(value = "主任务Id")
    private String taskId;
    
    @ApiModelProperty("员工任务Id")
    private String employTaskNumber;

    @ApiModelProperty("任务内容 1:指定表单 2:指定公告 3:指定链接 8:默认详情页")
    private String taskNote;

    @ApiModelProperty("任务内容信息")
    private String taskNoteContent;

    @ApiModelProperty("指定链接信息")
    private String taskNoteId;
    
    @ApiModelProperty(value = "催办时间")
    private LocalDateTime urgeTime;
    
    @ApiModelProperty(value = "描述 (催办说明)")
    private String actionDescribe;
    
    @ApiModelProperty(value = "是否撤销 0：未撤销 1：已撤销")
    private Integer isBack;
    
    @ApiModelProperty(value = "是否催办  0：未催办  1:已催办")
    private Integer isUrge;
    
    @ApiModelProperty(value = "查阅状态  0：未查阅  1：已查阅")
    private Integer isRead;
    
    @ApiModelProperty(value = "任务计划开始时间")
    private LocalDateTime taskPlanStartTime;
    
    @ApiModelProperty(value = "任务计划结束时间")
    private LocalDateTime taskPlanEndTime;
    
    @ApiModelProperty(value = "任务状态  0：待提交   1：已完成   2：已回收  3：已过期  4：整改中 5：待审核   6：审核中   7：待整改 8：已失效")
    private Integer taskState;
    
    @ApiModelProperty(value = "任务创建人")
    private String createBy;

    @ApiModelProperty(value = "计划执行人员工id")
    private Long planExecutorId;
    
    @ApiModelProperty(value = "计划执行人")
    private String planExecutor;
    
    @ApiModelProperty(value = "执行人信息")
    private EmployeeInfoRpcVO employeeInfoVO;

    @ApiModelProperty(value="完成数量")
    private Integer completeQuantity;

    @ApiModelProperty(value="任务总量")
    private Integer taskTotalQuantity;

    @ApiModelProperty(value="已查阅数量")
    private Integer readQuantity;

    @ApiModelProperty(value="查阅总量")
    private Integer needReadQuantity;
}
