package com.elitesland.sale2c.dto.syncPos;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel("零售单信息返回")
public class PSSale2cSoRpcDTO implements Serializable {

    @ApiModelProperty("单据编码")
    @Comment("单据编码")

    private String docNo;

    @ApiModelProperty("外部订单号（外卖)")
    @Comment("外部订单号（外卖)")

    private String outDocNo;

    @ApiModelProperty("单据类型")
    @Comment("单据类型")

    private String docType;

    @ApiModelProperty("单据状态")
    @Comment("单据状态")

    private String docStatus;

    @ApiModelProperty("经营性质")
    @Comment("经营性质")

    private String storeType2;

    @ApiModelProperty("渠道编码")
    @Comment("渠道编码")

    private String channelCode;

    @ApiModelProperty("渠道类型")
    @Comment("渠道类型")

    private String channelType;

    @ApiModelProperty("门店id")
    @Comment("门店id")

    private Long storeId;

    @ApiModelProperty("门店编码")
    @Comment("门店编码")

    private String storeCode;

    @ApiModelProperty("门店名称")
    @Comment("门店名称")

    private String storeName;

    @ApiModelProperty("公司ID")
    @Comment("公司ID")

    private Long ouId;

    @ApiModelProperty("公司编号")
    @Comment("公司编号")

    private String ouCode;

    @ApiModelProperty("公司名称")
    @Comment("公司名称")

    private String ouName;

    @ApiModelProperty("会员id")
    @Comment("会员id")

    private Long memberId;

    @ApiModelProperty("会员编号")
    @Comment("会员编号")

    private String memberCode;

    @ApiModelProperty("会员名称")
    @Comment("会员名称")

    private String memberName;

    @ApiModelProperty("加盟商id")
    @Comment("加盟商id")

    private Long custId;

    @ApiModelProperty("加盟商编号")
    @Comment("加盟商编号")

    private String custCode;

    @ApiModelProperty("加盟商名称")
    @Comment("加盟商名称")

    private String custName;

    @ApiModelProperty("零售金额")
    @Comment("零售金额")

    private BigDecimal retailAmt;

    @ApiModelProperty("应收金额")
    @Comment("应收金额")

    private BigDecimal receivableAmt;

    @ApiModelProperty("税额")
    @Comment("税额")

    private BigDecimal taxAmt;

    @ApiModelProperty("未税金额")
    @Comment("未税金额")

    private BigDecimal netReceivableAmt;

    @ApiModelProperty("汇率（默认为1）")
    @Comment("汇率（默认为1）")

    private BigDecimal currencyRate;

    @ApiModelProperty("本币含税金额")
    @Comment("本币含税金额")

    private BigDecimal receivableCurrencyAmt;

    @ApiModelProperty("本币未税金额")
    @Comment("本币未税金额")

    private BigDecimal netReceivableCurrencyAmt;

    @ApiModelProperty("本币税额")
    @Comment("本币税额")

    private BigDecimal currencyTaxAmt;

    @ApiModelProperty("实收金额")
    @Comment("实收金额")

    private BigDecimal receiptAmt;

    @ApiModelProperty("促销优惠金额")
    @Comment("促销优惠金额")

    private BigDecimal promotionDiscountsAmt;

    @ApiModelProperty("优惠券优惠金额")
    @Comment("优惠券优惠金额")

    private BigDecimal couponDiscountsAmt;

    @ApiModelProperty("储值卡优惠金额")
    @Comment("储值卡优惠金额")

    private BigDecimal cardDiscountsAmt;

    @ApiModelProperty("积分优惠金额")
    @Comment("积分优惠金额")

    private BigDecimal pointDiscountsAmt;

    @ApiModelProperty("第三方优惠金额")
    @Comment("第三方优惠金额")

    private BigDecimal thirdDiscountsAmt;

    @ApiModelProperty("第三方补贴")
    @Comment("第三方补贴")

    private BigDecimal thirdSubsidy;

    @ApiModelProperty("佣金点")
    @Comment("佣金点")

    private BigDecimal commissionPoint;

    @ApiModelProperty("运费")
    @Comment("运费")

    private BigDecimal freight;

    @ApiModelProperty("业务日期")
    @Comment("业务日期")

    private LocalDateTime businessDate;

    @ApiModelProperty("记账日期")
    @Comment("记账日期")

    private LocalDateTime glDate;

    @ApiModelProperty("系统来源")
    @Comment("系统来源")

    private String sysSource;

    @ApiModelProperty("同步错误信息")
    @Comment("同步错误信息")

    private String errorMsg;

    @ApiModelProperty("扣库标识")
    @Comment("扣库标识")

    private Boolean stockFlag;

    @ApiModelProperty("零售订单行")
    private List<PSSale2cSoDRpcDTO> psSale2cSoDRpcDTOS;
}
