package com.elitesland.sale2c.dto.syncPos;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel("零售单明细信息")
public class PSSale2cSoDRpcDTO implements Serializable {
    @ApiModelProperty("零售单ID")
    private Long masId;

    @ApiModelProperty("行号")
    private BigDecimal lineNo;

    @ApiModelProperty("行类型")
    private String lineType;

    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("仓库ID")
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("功能区")
    private String deter2;

    @ApiModelProperty("商品标价")
    private BigDecimal standardPrice;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("商品折扣")
    private BigDecimal discounts;

    @ApiModelProperty("商品零售价")
    private BigDecimal price;

    @ApiModelProperty("商品零售金额")
    private BigDecimal retailAmt;

    @ApiModelProperty("促销优惠金额")
    private BigDecimal promotionDiscountsAmt;

    @ApiModelProperty("优惠券优惠金额")
    private BigDecimal couponDiscountsAmt;

    @ApiModelProperty("储值卡优惠金额")
    private BigDecimal cardDiscountsAmt;

    @ApiModelProperty("积分优惠金额")
    private BigDecimal pointDiscountsAmt;

    @ApiModelProperty("第三方优惠金额")
    private BigDecimal thirdPartDiscountsAmt;

    @ApiModelProperty("第三方补贴")
    private BigDecimal thirdPartSubsidy;

    @ApiModelProperty("应收金额")
    private BigDecimal receivableAmt;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("未税金额")
    private BigDecimal netReceivableAmt;

    @ApiModelProperty("汇率（默认为1）")
    private BigDecimal currencyRate;

    @ApiModelProperty("本币含税金额")
    private BigDecimal receivableCurrencyAmt;

    @ApiModelProperty("本币未税金额")
    private BigDecimal netReceivableCurrencyAmt;

    @ApiModelProperty("本币税额")
    private BigDecimal currencyTaxAmt;

    @ApiModelProperty("已分配数量")
    private BigDecimal allocQty;

    @ApiModelProperty("菜品规格ID")
    private Long sizeId;

    @ApiModelProperty("菜品规格编码")
    private String sizeCode;

    @ApiModelProperty("菜品规格名称")
    private String sizeName;


}
