package com.elitesland.sale2c.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel("零售单查询入参")
public class Sale2cSoRpcParam implements Serializable {
    private static final long serialVersionUID = 177473942556104408L;

    @ApiModelProperty("零售单单号")
    private String docNo;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("扣库标记，true:已扣库 false:未扣库")
    private Boolean stockFlag;

    @ApiModelProperty("时间")
    private LocalDateTime dateTime;

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("零售单单号List")
    private List<String> docNos;
}
