package com.elitesland.after.sale.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author Danny.Wang
 * @title CarOwnerVehicleSaveVO
 * @Date2023/2/8 14:36
 */
@Data
@ApiModel(description = "车辆激活信息出参")
public class AfterSaleVehicleRespDTO implements Serializable {

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty("所属客户编码")
    private String custCode;

    @ApiModelProperty("所属客户号")
    private String custCode2;

    @ApiModelProperty("所属客户名称")
    private String custName;

    @ApiModelProperty("区域")
    private String region;

    @ApiModelProperty("类型")
    private String docType;

    @ApiModelProperty("业务员关系路径")
    private String salesmanPath;

    @ApiModelProperty("车型")
    private String itemType5;

    @ApiModelProperty("总出货量")
    private BigDecimal shipQty;

    @ApiModelProperty("统计时间")
    private LocalDateTime docTime;

    @ApiModelProperty("统计时间")
    private LocalDate data;

}
