/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.bdata.util;

import com.esotericsoftware.reflectasm.MethodAccess;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class BeanUtils
extends org.apache.commons.beanutils.BeanUtils {
    private static final Logger log = LoggerFactory.getLogger(BeanUtils.class);
    private static Map<Class<?>, MethodAccess> methodMap = new ConcurrentHashMap();
    private static Map<String, Integer> methodIndexMap = new ConcurrentHashMap<String, Integer>();
    private static Map<Class<?>, List<String>> fieldMap = new ConcurrentHashMap();
    private static final byte[] LOCK = new byte[0];

    public static boolean propertyExists(Object bean, String name) {
        try {
            BeanUtils.getProperty((Object)bean, (String)name);
            return true;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException var3) {
            return false;
        }
        catch (RuntimeException var4) {
            return false;
        }
    }

    public static void setPropertyLombok(Object bean, String name, Object value) {
        Method[] methods = bean.getClass().getMethods();
        Method method = BeanUtils.findMethodByName(methods, "set" + BeanUtils.toUpperCaseFirstOne(name));
        try {
            method.invoke(bean, value);
        }
        catch (Exception var6) {
            log.error("setPropertyLombok exception", (Throwable)var6);
        }
    }

    private static Method findMethodByName(Method[] methods, String name) {
        for (int j = 0; j < methods.length; ++j) {
            if (!methods[j].getName().equals(name)) continue;
            return methods[j];
        }
        return null;
    }

    public static void copyPropertiesExcludeId(Object destObj, Object sourceObj) {
        BeanUtils.copyPropertiesExclude(destObj, sourceObj, "id");
    }

    public static <T> T copyPropertiesExcludeId(Class<T> destClazz, Object sourceObj) {
        T descObj = null;
        try {
            descObj = destClazz.newInstance();
            BeanUtils.copyPropertiesExclude(descObj, sourceObj, "id");
        }
        catch (InstantiationException var4) {
            log.error("InstantiationException", (Throwable)var4);
        }
        catch (IllegalAccessException var5) {
            log.error("IllegalAccessException", (Throwable)var5);
        }
        catch (IllegalArgumentException var6) {
            log.error("IllegalArgumentException", (Throwable)var6);
        }
        catch (SecurityException var7) {
            log.error("SecurityException", (Throwable)var7);
        }
        return descObj;
    }

    public static <T> T copyPropertiesExclude(Class<T> destClazz, Object sourceObj, String ... properties) {
        T descObj = null;
        try {
            descObj = destClazz.newInstance();
            BeanUtils.copyPropertiesExclude(descObj, sourceObj, properties);
        }
        catch (InstantiationException var5) {
            log.error("InstantiationException", (Throwable)var5);
        }
        catch (IllegalAccessException var6) {
            log.error("IllegalAccessException", (Throwable)var6);
        }
        catch (IllegalArgumentException var7) {
            log.error("IllegalArgumentException", (Throwable)var7);
        }
        catch (SecurityException var8) {
            log.error("SecurityException", (Throwable)var8);
        }
        return descObj;
    }

    public static void copyPropertiesExclude(Object desc, Object orgi, String ... properties) {
        ArrayList<String> list = new ArrayList<String>(properties.length);
        String[] var4 = properties;
        int var5 = properties.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            String property = var4[var6];
            list.add(BeanUtils.toUpperCaseFirstOne(property));
        }
        BeanUtils.copy(desc, orgi, desc.getClass(), orgi.getClass(), true, list);
    }

    public static <T> T copyProperties(Class<T> destClazz, Object sourceObj) {
        return BeanUtils.copyProperties(destClazz, sourceObj, (Map<String, String>)null);
    }

    public static <O, T> List<T> copyList(Class<T> destClazz, List<O> sourceObjList) {
        if (CollectionUtils.isEmpty(sourceObjList)) {
            return null;
        }
        ArrayList resultList = new ArrayList();
        sourceObjList.forEach(o -> {
            Object t = BeanUtils.copyProperties(destClazz, o);
            resultList.add(t);
        });
        return resultList;
    }

    public static <T> T copyProperties(Class<T> destClazz, Object sourceObj, Map<String, String> propertyMap) {
        T descObj = null;
        try {
            descObj = destClazz.newInstance();
            BeanUtils.copyProperties(descObj, sourceObj, propertyMap);
        }
        catch (InstantiationException var5) {
            log.error("InstantiationException", (Throwable)var5);
        }
        catch (IllegalAccessException var6) {
            log.error("IllegalAccessException", (Throwable)var6);
        }
        catch (IllegalArgumentException var7) {
            log.error("", (Throwable)var7);
        }
        catch (SecurityException var8) {
            log.error("IllegalArgumentException", (Throwable)var8);
        }
        return descObj;
    }

    public static void copyProperties(Object desc, Object orgi) {
        BeanUtils.copy(desc, orgi, desc.getClass(), orgi.getClass(), false, null, null);
    }

    public static void copyProperties(Object desc, Object orgi, Map<String, String> params) {
        BeanUtils.copy(desc, orgi, desc.getClass(), orgi.getClass(), false, null, params);
    }

    private static void copy(Object desc, Object orgi, Class<?> descClass, Class<?> origClass, boolean flag, List<String> properties) {
        BeanUtils.copy(desc, orgi, descClass, origClass, flag, properties, null);
    }

    private static void copy(Object destObj, Object sourceObj, Class<?> destClass, Class<?> sourceClass, boolean flag, List<String> properties, Map<String, String> params) {
        MethodAccess orgiMethodAccess;
        MethodAccess destMethodAccess = methodMap.get(destClass);
        if (destMethodAccess == null) {
            destMethodAccess = BeanUtils.cache(destClass);
        }
        if ((orgiMethodAccess = methodMap.get(sourceClass)) == null) {
            orgiMethodAccess = BeanUtils.cache(sourceClass);
        }
        List<String> fieldList = fieldMap.get(sourceClass);
        Iterator<String> var10 = fieldList.iterator();
        while (var10.hasNext()) {
            Method method;
            int getIndex;
            Object sourceVal;
            String getKey;
            String field = var10.next();
            boolean booleanflag = false;
            if (field.startsWith("boolean|")) {
                booleanflag = true;
                field = field.substring(field.indexOf("|") + 1, field.length());
                getKey = sourceClass.getName() + ".is" + field;
            } else {
                getKey = sourceClass.getName() + ".get" + field;
            }
            if (flag && properties.contains(field)) continue;
            String destField = null;
            destField = params != null ? (StringUtils.isEmpty((Object)(destField = params.get(BeanUtils.toLowerCaseFirstOne(field)))) ? field : BeanUtils.toUpperCaseFirstOne(destField)) : field;
            String setkey = destClass.getName() + ".set" + destField;
            Integer setIndex = methodIndexMap.get(setkey);
            if (setIndex == null || (sourceVal = orgiMethodAccess.invoke(sourceObj, getIndex = methodIndexMap.get(getKey).intValue(), new Object[0])) == null) continue;
            if (!(BeanUtils.isPrimitive(sourceVal) || String.class.equals(sourceVal.getClass()) || sourceVal instanceof List || BigDecimal.class.equals(sourceVal.getClass()) || Date.class.equals(sourceVal.getClass()))) {
                if (!(sourceVal instanceof List)) {
                    try {
                        method = booleanflag ? BeanUtils.findMethodByName(destClass.getMethods(), "is" + destField) : BeanUtils.findMethodByName(destClass.getMethods(), "get" + destField);
                        Type type = method.getGenericReturnType();
                        Class clzz = (Class)type;
                        Object destValObj = BeanUtils.copyProperties(clzz, sourceVal);
                        destMethodAccess.invoke(destObj, setIndex.intValue(), new Object[]{destValObj});
                    }
                    catch (Exception var28) {
                        log.error("\u64cd\u4f5c\u5f02\u5e38", (Throwable)var28);
                    }
                }
            } else {
                destMethodAccess.invoke(destObj, setIndex.intValue(), new Object[]{sourceVal});
            }
            try {
                ParameterizedType pt;
                Type typeTemp;
                Type type;
                Object val;
                if (destObj == null || booleanflag || !((val = (method = BeanUtils.findMethodByName(destClass.getMethods(), "get" + destField)).getReturnType().cast(method.invoke(destObj, new Object[0]))) instanceof List) || "java.util.List".equals((type = method.getGenericReturnType()).getTypeName())) continue;
                Class clzz = null;
                if (type instanceof ParameterizedType && ("?".equals((typeTemp = (pt = (ParameterizedType)type).getActualTypeArguments()[0]).getTypeName()) || BeanUtils.isWrapClass(clzz = (Class)typeTemp) || String.class.equals((Object)clzz) || BigDecimal.class.equals((Object)clzz) || Date.class.equals((Object)clzz))) continue;
                List valList = (List)val;
                ArrayList listb = new ArrayList();
                for (Object valObj : valList) {
                    Object destValObj = BeanUtils.copyProperties(clzz, valObj);
                    listb.add(destValObj);
                }
                destMethodAccess.invoke(destObj, setIndex.intValue(), new Object[]{listb});
                continue;
            }
            catch (Exception var29) {
                log.error("\u64cd\u4f5c\u5f02\u5e38", (Throwable)var29);
                continue;
            }
            break;
        }
        return;
    }

    private static boolean isPrimitive(Object obj) {
        try {
            return ((Class)obj.getClass().getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception var2) {
            return false;
        }
    }

    private static boolean isWrapClass(Class clz) {
        try {
            return ((Class)clz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception var2) {
            return false;
        }
    }

    private static String toUpperCaseFirstOne(String s) {
        return Character.isUpperCase(s.charAt(0)) ? s : Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String toLowerCaseFirstOne(String s) {
        return Character.isLowerCase(s.charAt(0)) ? s : Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static List<Field> getAllFields(Class<?> orgiClass) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> tempClass = orgiClass; tempClass != null && !tempClass.getName().toLowerCase().equals("java.lang.object"); tempClass = tempClass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        return fieldList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MethodAccess cache(Class<?> orgiClass) {
        byte[] byArray = LOCK;
        synchronized (LOCK) {
            MethodAccess methodAccess = methodMap.get(orgiClass);
            if (methodAccess != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return methodAccess;
            }
            methodAccess = MethodAccess.get(orgiClass);
            List<Field> fields = BeanUtils.getAllFields(orgiClass);
            ArrayList<Object> fieldList = new ArrayList<Object>();
            for (Field field : fields) {
                int setIndex;
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
                String fieldName = StringUtils.capitalize((String)field.getName());
                Class<?> type = field.getType();
                if (Boolean.TYPE.equals(type)) {
                    setIndex = methodAccess.getIndex("is" + fieldName);
                    methodIndexMap.put(orgiClass.getName() + ".is" + fieldName, setIndex);
                    fieldList.add("boolean|" + fieldName);
                } else {
                    setIndex = methodAccess.getIndex("get" + fieldName);
                    methodIndexMap.put(orgiClass.getName() + ".get" + fieldName, setIndex);
                    fieldList.add(fieldName);
                }
                setIndex = methodAccess.getIndex("set" + fieldName);
                methodIndexMap.put(orgiClass.getName() + ".set" + fieldName, setIndex);
            }
            fieldMap.put(orgiClass, fieldList);
            methodMap.put(orgiClass, methodAccess);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return methodAccess;
        }
    }
}

