package com.elitesland.order.service;

import com.elitesland.order.param.SalDoDExamDTO;
import com.elitesland.order.param.SalDoDQueryDTO;
import com.elitesland.order.param.SalDoDRPCRespDTO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * @author Shadow
 * @since 2021-07-12 9:11
 */
public interface SalDoDRpcService {
    /**
     * 查询发货单
     * @param salDoDQueryDTO 查询参数
     * @return 发货单
     */
    ApiResult<PagingVO<SalDoDRPCRespDTO>> queryDodForInvoice(SalDoDQueryDTO salDoDQueryDTO);
    /**
     * 更新发货单对账状态
     * @param ids 明细ID列表
     * @param soaStatus 状态
     * @return 是否成功
     */
    ApiResult<String> updateSoaStatus(List<Long> ids,String soaStatus);
    /**
     * 验收时查询发货单
     * @param salDoDQueryDTO 查询参数
     * @return 发货单
     */
    ApiResult<List<SalDoDRPCRespDTO>> queryDodForExam(SalDoDQueryDTO salDoDQueryDTO);
    /**
     * <p>更新发货单验收数量字段</p>
     * @param salDoDExamDTOS 更新参数
     * @return 是否成功
     */
    ApiResult<String> updateSalDoDForExam(List<SalDoDExamDTO> salDoDExamDTOS);
}
