package com.elitesland.order.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 物流信息(SalLogislog)保存对象
 *
 * @author evin.dong
 * @since 2021-06-17 10:55:07
 */

@Data
@ApiModel(value = "SalLogislogSaveVO", description = "物流信息")
public class SalLogislogSaveDTO implements Serializable {
    private static final long serialVersionUID = -6726129325612358550L;
    /**
    * 记录唯一ID
    */    
    @ApiModelProperty(value = "记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
    * 主表ID SAL_SO.ID
    */
    @ApiModelProperty(value = "主表ID SAL_SO.ID",required = true)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;
    /**
    * 销售订单ID
    */
    @ApiModelProperty(value = "销售订单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long soId;
    /**
    * 销售订单明细ID
    */
    @ApiModelProperty(value = "销售订单明细ID",required = true)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long soDId;

    /**
     * 配送方式
     */
    @ApiModelProperty(value = "配送方式",required = true)
    private String deliverMethod;

    /**
     * 物流公司ID
     */
    @ApiModelProperty(value = "物流公司ID",required = true)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long logisCarrierId;
    /**
     * 物流公司编号
     */
    @ApiModelProperty(value = "物流公司编号",required = true)
    private String logisCarrierCode;
    /**
     * 物流公司名称
     */
    @ApiModelProperty(value = "物流公司名称",required = true)
    private String logisCarrierName;
    /**
     * 物流单号
     */
    @ApiModelProperty(value = "物流单号",required = true)
    private String logisDocNo;
    /**
     * 物流费用
     */
    @ApiModelProperty(value = "物流费用")
    private BigDecimal logisFee;
    /**
     * 发货时间
     */
    @ApiModelProperty(value = "发货时间",required = true)
    private String logisTime;
    /**
     * 物流配送人
     */
    @ApiModelProperty(value = "物流配送人",required = true)
    private String logisContactName;
    /**
     * 配送人联系方式
     */
    @ApiModelProperty(value = "配送人联系方式",required = true)
    private String logisContactTel;
}