package com.elitesland.order.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class SalSoRespDTO implements Serializable {

    private static final long serialVersionUID = 7844185829635901969L;
    /**
     * 店铺名称
     */
    @ApiModelProperty("店铺名称")
    private String storeName;

    @ApiModelProperty("排期类型")
    private String scheduleType;
    /**
     * 平台订单号
     */
    @ApiModelProperty("平台订单号")
    private String docNo2;

    /**
     * 订单创建日期
     */
    @ApiModelProperty("订单创建日期")
    private LocalDateTime createTime;

    /**
     * 收货人
     */
    @ApiModelProperty("收货人")
    private String custContactName;

    /**
     * 收货人电话
     */
    @ApiModelProperty("收货人电话")
    private String custContactTel;

    /**
     * 收货国家
     */
    @ApiModelProperty("收货国家")
    private String recvCountry;
    /**
     * 收货省份
     */
    @ApiModelProperty("收货省份")
    private String recvProvince;
    /**
     * 收货省份Name
     */
    @ApiModelProperty("收货省份Name")
    private String recvProvinceName;
    /**
     * 城市
     */
    @ApiModelProperty("城市(编号/ID)")
    private String recvCity;
    @ApiModelProperty("城市名称")
    private String recvCityName;
    /**
     * 区县
     */
    @ApiModelProperty("区县(编号/ID)")
    private String recvCounty;
    @ApiModelProperty("区县名称")
    private String recvCountyName;

    /**
     * 收货地址拼接
     */
    @ApiModelProperty("收货地址拼接")
    private String recvAddress;

    /**
     * 收货详细地址
     */
    @ApiModelProperty("收货详细地址")
    private String recvDetailaddr;

    /**
     * 发货状态
     */
    @ApiModelProperty("发货状态:UDC[SAL:SO_LOGIS_STATUS]")
    private String logisStatus;
    /**
     * 订单状态
     */
    @ApiModelProperty("订单状态")
    private String docStatus;

    /**
     * 销售订单id
     */
    @ApiModelProperty("销售订单id")
    private Long id;

    /**
     * 指定送货日期
     */
    @ApiModelProperty("指定送货日期")
    private LocalDateTime specifySendDate;

    /**
     * 指定送货时间
     */
    @ApiModelProperty("指定送货时间")
    private LocalDateTime specifySendTime;

    /**
     * 买家留言
     */
    @ApiModelProperty("买家留言")
    private String remarkBuyer;

    /**
     * 卖家备注
     */
    @ApiModelProperty("卖家备注")
    private String remarkSeller;

    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @NotEmpty(message = "供应商ID不能为空")
    private Long suppId;
    /**
     * 销售订单号
     */
    @ApiModelProperty("销售订单号")
    private String docNo;


    @ApiModelProperty("商品名称")
    private String itemName;


    /**
     * 商品id
     */
    @ApiModelProperty("商品id")
    private Long itemId;
    /**
     * 商品编号
     */
    @ApiModelProperty("商品编号")
    private String itemCode;

    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String itemBrand;


    @ApiModelProperty("单据类型 [UDC]SAL:SO_TYPE'")
    private String docType;
    @ApiModelProperty("订单日期")
    private LocalDateTime docTime;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("供应商编号")
    private String suppCode;

    /**
     * 订单明细
     */
    private List<SalSoItemRespDTO> itemRespDTOList;


    @ApiModelProperty("指定送货时间")
    private LocalDateTime demandTimespan;

}
