package com.elitesland.order.service;

import com.elitesland.order.Application;
import com.elitesland.order.param.SalSoDQueryDTO;
import com.elitesland.order.param.SalSoDRefundRespDTO;
import com.elitesland.order.param.SalSoDUpdateDTO;
import com.elitesland.order.param.SalSoReceiptSaveDTO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author Shadow
 * @since  2021/06/24 9:40
 */
public interface SalSoDUpdateRpcService {

    /**
     * 收款单提交/拒绝时，更新销售订单明细
     * @param salSoDUpdateDTO 需要保存的字段
     * @return 是否成功
     */
    ApiResult<String> updateWhenSubmitOrRefuse(@NotNull(message = "参数值不能为空") SalSoDUpdateDTO salSoDUpdateDTO);
    /**
     * 收款单提交/拒绝时，批量修改
     */
    ApiResult<String> updateWhenSubmitOrRefuse(@NotNull(message = "参数值不能为空") List<SalSoDUpdateDTO> salSoDUpdateDTOS);
    /**
     * <p>财务核销/红冲时，更新订单明细并生成收款单</p>
     * <p>红冲时，收款单的RECEIPT_AMT、RECEIPT_TAX 金额必须为负值的</p>
     * @param receiptSaveDTOS 需新增的收款单
     * @return 是否成功
     */
    ApiResult<String> updateWhenVerifyOrReverse(List<SalSoReceiptSaveDTO> receiptSaveDTOS);




    /**
     * 退货单查询
     * @param salSoDQueryDTO 查询参数
     * @return 退货单信息
     */
    ApiResult<PagingVO<SalSoDRefundRespDTO>> queryRefund(SalSoDQueryDTO salSoDQueryDTO);
    /**
     * 退款单提交
     * @param IdAndAmt ID AMT
     * @return 成功信息
     */
    ApiResult<String> submitRefund(Map<Long,BigDecimal> IdAndAmt);
    /**
     * 批准
     */
    ApiResult<String> approveRefund(Map<Long,BigDecimal> IdAndAmt);
    /**
     * 拒绝
     */
    ApiResult<String> rejectRefund(Map<Long,BigDecimal> IdAndAmt);
}
