package com.elitesland.order.service;

import com.elitesland.order.Application;
import com.elitesland.order.param.SalDoDAndSoReturnRespDTO;
import com.elitesland.order.param.SalDoReturnQueryDTO;
import com.elitesland.order.param.SalDoReturnSaveDTO;
import com.elitesland.order.param.SalDoReturnTOBSaveDTO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * 退货收货单对外提供服务接口
 *
 * @author Dave
 * @date 2021-05-31
 */
public interface SalDoReturnRpcService {


    /**
     * ①按照退货收货单的维度显示 销售退货单信息和采购退货单信息。
     * ②单据间关系：订单中心退货收货单由订单中心销售退货单作为数据源生成，采购中心采购退货单由 订单中心退货收货单作为数据源生成。
     * 支持分页查询。
     *
     * @param salDoReturnQueryDTO 查询参数条件
     * @return 退货收货单信息分页查询
     */
    ApiResult<PagingVO<SalDoDAndSoReturnRespDTO>> querySalDoD(@NotNull(message = "退货收货单入参为空") SalDoReturnQueryDTO salDoReturnQueryDTO);


    /**
     * 供应商协同一件代退-退货收货单
     *
     * @param returnDIds 退货单明细ids
     * @param qty        实收退货数量,不存在传入null
     * @param returnFlag 是否修改退货方式为“退货退款”。 1：是 其他否
     * @return 退货收货单创建成功/失败-成功返回退货收货单号docNos；失败返回错误信息
     */
    ApiResult<List<String>> returnStoreByIds(@NotEmpty(message = "退货单明细id为空") List<Long> returnDIds, BigDecimal qty, String returnFlag);

    /**
     * 供应商协同一件代退-退货收货单
     *
     * @param returnId 退货单主表ID
     * @param qty        实收退货数量,不存在传入null
     * @param returnFlag 是否修改退货方式为“退货退款”。 1：是 其他否
     * @return 退货收货单创建成功/失败-成功返回退货收货单号docNos；失败返回错误信息
     */
    ApiResult<List<String>> returnStoreByReturnId(@NotNull(message = "退货单主表id为空") Long returnId, BigDecimal qty, String returnFlag);

    /**
     * 更新物流信息接口（包括B端商城）
     *
     * @param vo 退货订单编号及物流信息
     * @return ApiResult<String>
     */
    ApiResult<String> updateTOBLogisInfo(SalDoReturnTOBSaveDTO vo);


    /**
     * 团内退货&旧件返还业务
     *
     * @param dtos 采购退货登记单及明细信息
     * @return 退货收货单创建成功/失败-成功返回退货收货单号docNos；失败返回错误信息
     */
    ApiResult<List<String>> saveDoReturn(List<SalDoReturnSaveDTO> dtos);
}
