package com.elitesland.order.service;

import com.elitesland.order.Application;
import com.elitesland.order.param.SalSoAllocCancleReqDto;
import com.elitesland.order.param.SalSoCancleReqDto;
import com.elitesland.order.param.SalSoDRespDTO;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;

import javax.validation.constraints.NotEmpty;
import java.util.List;


public interface SalSoDRpcService {


    /**
     * 采购单----取消订单
     * 根据采购单去配货表中删除
     */
    ApiResult<Boolean> cnnnelDoByRelateDocIdAndRelateDocDid(@NotEmpty(message = "message = 参数值不能为空") List<SalSoCancleReqDto> salSoCancleReqDtos);

    /**
     *【配货数量取消】针对越库生成采购订单的场景，需要给供应链一个接口
     * 订单域提供取消配货数量的接口，由采购域在做部分数量取消时，判断是越库的场景，则调用此接口：
     * 1）根据取消数量，对此条采购订单明细对应的配货明细的配货数量进行减法，如果减成0，则逻辑删除此条配货明细。
     * 2）更新订单明细的配货数量，配货状态。
     *
     * @param soAllocCancleReqDtoList
     * @return
     */
    ApiResult<Boolean> cancelAllocForPO(@NotEmpty(message = "message = 参数值不能为空") List<SalSoAllocCancleReqDto> soAllocCancleReqDtoList);

    /**
     *c端销售订单明细批量查询
     */
    List<SalSoDRespDTO> querySalSoDByIds(@NotEmpty(message = "message = 参数值不能为空") List<Long> ids);
}
