package com.elitesland.order.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.order.param
 * @date 2023/8/24 11:00
 */
@Data
public class SalDoLogisRpcDTO implements Serializable {

    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 主表ID SAL_SO.ID
     */
    @ApiModelProperty("主表ID SAL_SO.ID")
    private Long masId;
    /**
     * 销售订单ID
     */
    @ApiModelProperty("销售订单ID")
    private Long soId;

    @ApiModelProperty("销售单据ID")
    private Long relateDocId;

    /**
     * 销售订单明细ID
     */
    @ApiModelProperty("销售订单明细ID")
    private Long soDId;
    /**
     * 发货单ID
     */
    @ApiModelProperty("发货单ID")
    private Long doId;
    /**
     * 发货单明细ID
     */
    @ApiModelProperty("发货单明细ID")
    private Long doDId;

    /**
     * 配送方式
     */
    @ApiModelProperty("配送方式")
    private String deliverMethod;

    /**
     * 物流公司ID
     */
    @ApiModelProperty("物流公司ID")
    private Long logisCarrierId;
    /**
     * 物流公司编号
     */
    @ApiModelProperty("物流公司编号")
    private String logisCarrierCode;
    /**
     * 物流公司名称
     */
    @ApiModelProperty("物流公司名称")
    private String logisCarrierName;
    /**
     * 物流单号
     */
    @ApiModelProperty("物流单号")
    private String logisDocNo;
    /**
     * 物流费用
     */
    @ApiModelProperty("物流费用")
    private BigDecimal logisFee;
    /**
     * 发货时间
     */
    @ApiModelProperty("发货时间")
    private LocalDateTime logisTime;
    /**
     * 物流配送人
     */
    @ApiModelProperty("物流配送人")
    private String logisContactName;
    /**
     * 配送人联系方式
     */
    @ApiModelProperty("配送人联系方式")
    private String logisContactTel;

    @ApiModelProperty("出库单id")
    private Long odoId;


    @ApiModelProperty("发货单明细id")
    List<SalDoDRpcDTO> salDoDRpcDTOList;

}
