package com.elitesland.order.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.order.Application;
import com.elitesland.order.param.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.concurrent.ExecutionException;

@FeignClient(name = Application.NAME, path = Application.PATH + SalSoRpcService.PATH)
@Validated
public interface SalSoRpcService {
    String PATH = "/salSoRpc";

    /**
     * 查询合同条目已生成订单中的数量
     *
     * @param
     * @return
     */
    @GetMapping("/findHaveOrderQty")
    List<ContractQtyDTO> findHaveOrderQty(@RequestBody QueryContractDTO queryContractDTO);


    @GetMapping("/updatePurStatus")
    ApiResult<Object> updatePurStatus(@RequestParam("ids") List<Long> ids, @RequestParam("status") String status);

    /**
     * B端商城正向订单接入
     *
     * @param salSoSaveDTO
     * @return
     * @throws ExecutionException
     * @throws InterruptedException
     */
    @PostMapping("/ToBOrderSave")
    ApiResult<List<OrderReturnDTO>> ToBOrderSave(@RequestBody ToBSalSoSaveDTO salSoSaveDTO) throws ExecutionException, InterruptedException;

    /**
     * 支付完成更新订单状态
     *
     * @param
     * @return
     */
    @PostMapping("/updateSalsoStatus")
    ApiResult<Long> updateSalsoStatus(@RequestBody SalSoUpdateParam salSoUpdateParam);

    /**
     * 判断团内订单是否能关闭
     *
     * @param
     * @return
     */
    @GetMapping("/judgeCanCloseGroupOrder")
    ApiResult<SalSoCancelDTO> judgeCanCloseGroupOrder(@RequestParam("salSoId") Long salSoId);

    /**
     * 关闭
     *
     * @param salSoSaveDTO
     * @return
     */
    @GetMapping("/closeGroupOrder")
    ApiResult<Boolean> closeGroupOrder(@RequestParam("salSoSaveDTO") @NotNull(message = "参数值不能为空") SalSoCloseDTO salSoSaveDTO);


    @GetMapping("/orderDetail")
    ApiResult<SalSoRespDTO> orderDetail(@RequestParam("docNo") @NotBlank(message = "平台订单号不能为空") String docNo, @RequestParam("suppId") Long suppId) throws ExecutionException, InterruptedException;

    /***
     * 根据客户编码、合同号查询销售订单明细信息
     * 成功返回 销售订单明细信息
     * @param searchParam 查询入参
     */
    @GetMapping("/querySalSoDetail")
    ApiResult<PagingVO<SalSoDetailRespDTO>> querySalSoDetail(@RequestBody SalSoDetailQueryDTO searchParam);

    /**
     * 集团内订单
     *
     * @param
     * @return
     */
    @PostMapping("/groupOrderSave")
    ApiResult<Long> groupOrderSave(@RequestBody SalSoSaveDTO salSoSaveDTO);


    /**
     * 更新采购配货明细
     *
     * @param salSoAllocDTOS
     * @return
     */
    @PostMapping("/updateSalSoAllocInfo")
    ApiResult<Long> updateSalSoAllocInfo(@RequestBody List<SalSoAllocRespDTO> salSoAllocDTOS);


    /**
     * 更新采购配货明细
     *
     * @param salSoAllocDTOS
     * @return
     */
    @PostMapping("/updateSySalSoAllocInfo")
    ApiResult<Long> updateSySalSoAllocInfo(@RequestBody List<SalSoAllocRespDTO> salSoAllocDTOS);

    /**
     * 销转外采-采购订单关闭
     *
     * @param paramDTO
     * @return
     */
    @PostMapping("/cancelPurToSoOrder")
    ApiResult<Object> cancelSoToPoOrder(@RequestBody SalSoCancelParamDTO paramDTO);

    /**
     * 采转销-采购订单关闭
     *
     * @param salSoId
     * @return
     */
    @GetMapping("/cancelPurToSoOrder")
    ApiResult<Object> cancelPurToSoOrder(@RequestParam("salSoId") Long salSoId);
}
