package com.elitesland.order.param;

import lombok.Data;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

import io.swagger.annotations.ApiModel;



/**
 * @author : WWW
 * @date : 2023-9-11
 * @desc : 销售对账报表
 */

@Data
@ApiModel(description = "销售对账报表")
public class SaleReconciliatDTO implements Serializable {

    private List<Long> ids;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 对账单号
     */
    @ApiModelProperty("对账单号")
    private String docNo;

    /**
     * 对账状态
     */
    @ApiModelProperty("对账状态")
    private String state;

    /**
     * 销售公司id
     */
    @ApiModelProperty("销售公司id")
    private Long ouId;

    /**
     * 销售公司名称
     */
    @ApiModelProperty("销售公司名称")
    private String ouName;

    /**
     * 销售公司编码
     */
    @ApiModelProperty("销售公司编码")
    private String ouCode;

    /**
     * 部门id
     */
    @ApiModelProperty("部门id")
    private Long buId;

    /**
     * 部门编码
     */
    @ApiModelProperty("部门编码")
    private String buCode;

    /**
     * 部门名称
     */
    @ApiModelProperty("部门名称")
    private String buName;

    /**
     * 对账开始时间
     */
    @ApiModelProperty("对账开始时间")
    private LocalDateTime recStartTime;

    /**
     * 对账结束时间
     */
    @ApiModelProperty("对账结束时间")
    private LocalDateTime recEndTime;

    /**
     * 对账人id
     */
    @ApiModelProperty("对账人id")
    private Long recUserId;

    /**
     * 对账人编码
     */
    @ApiModelProperty("对账人编码")
    private String recUserCode;

    /**
     * 对账人名称
     */
    @ApiModelProperty("对账人名称")
    private String recUserName;

    /**
     * 客户id
     */
    @ApiModelProperty("客户id")
    private Long custId;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    private String custCode;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String custName;

    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;

    /**
     * 本位币种
     */
    @ApiModelProperty("本位币种")
    private String localCurr;

    /**
     * 汇率
     */
    @ApiModelProperty("汇率")
    private BigDecimal currRate;

    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额")
    private BigDecimal includTaxAmt;

    /**
     * 不含税金额
     */
    @ApiModelProperty("不含税金额")
    private BigDecimal excludTaxAmt;

    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    /**
     * 客户联系人名称
     */
    @ApiModelProperty("客户联系人名称")
    private String custContactName;

    /**
     * 客户联系人电话
     */
    @ApiModelProperty("客户联系人电话")
    private String custContactTel;

    /**
     * 对账联系人电话
     */
    @ApiModelProperty("对账联系人电话")
    private String recTel;

    /**
     * 含税金额（本位币）
     */
    @ApiModelProperty("含税金额（本位币）")
    private BigDecimal includTaxAmtLocal;

    /**
     * 不含税金额(本位币)
     */
    @ApiModelProperty("不含税金额(本位币)")
    private BigDecimal excludTaxAmtLocal;

    /**
     * 税额(本位币)
     */
    @ApiModelProperty("税额(本位币)")
    private BigDecimal taxAmtLocal;

    /**
     * 审核人id
     */
    @ApiModelProperty("审核人id")
    private Long auditUserId;

    /**
     * 审核人编码
     */
    @ApiModelProperty("审核人编码")
    private String auditUserCode;

    /**
     * 审核人名称
     */
    @ApiModelProperty("审核人名称")
    private String auditUserName;

    /**
     * 审核时间
     */
    @ApiModelProperty("审核时间")
    private LocalDateTime auditTime;

    /**
     * 审核说明
     */
    @ApiModelProperty("审核说明")
    private String auditDesc;

    /**
     * 收款状态
     */
    @ApiModelProperty("收款状态")
    private String recState;

    /**
     * 开票状态
     */
    @ApiModelProperty("开票状态")
    private String invState;

    /**
     * 收款单号
     */
    @ApiModelProperty("收款单号")
    private String recNo;

    /**
     * 待收款金额
     */
    @ApiModelProperty("待收款金额")
    private BigDecimal unRecAmt;

    /**
     * 收款中金额
     */
    @ApiModelProperty("收款中金额")
    private BigDecimal recingAmt;

    /**
     * 已收款金额
     */
    @ApiModelProperty("已收款金额")
    private BigDecimal recdAmt;

    /**
     * 开票申请单号
     */
    @ApiModelProperty("开票申请单号")
    private String invApplyNo;

    /**
     * 待开票金额
     */
    @ApiModelProperty("待开票金额")
    private BigDecimal unInvAmt;

    /**
     * 开票中金额
     */
    @ApiModelProperty("开票中金额")
    private BigDecimal invingAmt;

    /**
     * 已开票金额
     */
    @ApiModelProperty("已开票金额")
    private BigDecimal invdAmt;

    /**
     * 客户联系人
     */
    @ApiModelProperty("客户联系人")
    private Long custContactId;

    /**
     * 客户联系人
     */
    @ApiModelProperty("客户联系人")
    private String custContactCode;

    /**
     * 费用含税金额
     */
    @ApiModelProperty("费用含税金额")
    private BigDecimal feeAmt;

    /**
     * 费用未税金额
     */
    @ApiModelProperty("费用未税金额")
    private BigDecimal feeNetAmt;

    /**
     * 票扣含税金额
     */
    @ApiModelProperty("票扣含税金额")
    private BigDecimal invDiscountAmt;

    /**
     * 票扣未税金额
     */
    @ApiModelProperty("票扣未税金额")
    private BigDecimal invDiscountNetAmt;


    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;


    /**
     * 确认时间
     */
    @ApiModelProperty("确认时间")
    private LocalDateTime confirmTime;

    /**
     * 主客户编码
     */
    @ApiModelProperty("主客户编码")
    private String mainCustCode;

    /**
     * 主客户id
     */
    @ApiModelProperty("主客户id")
    private Long mainCustId;

    /**
     * 主客户名称
     */
    @ApiModelProperty("主客户名称")
    private String mainCustName;

    /**
     * 对账单明细集合
     */
    @ApiModelProperty("对账单明细集合")
    private List<SaleReconciliatDtlDTO> saleReconciliatDtlDTOList;

}

