package com.elitesland.order.param;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.time.LocalDateTime;


@Data
public class SalSoReturnRespDTO implements Serializable {

    private static final long serialVersionUID = -798590119594974300L;
    /**
     * 退货单id
     */
    @ApiModelProperty("退货单id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 退货单明细id
     */
    @ApiModelProperty("退货单明细id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long did;

    /**
     * 店铺id
     */
    @ApiModelProperty("店铺id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    /**
     * 店铺名称
     */
    @ApiModelProperty("店铺名称")
    private String buName;

    /**
     * 退货订单号
     */
    @ApiModelProperty("退货订单号")
    private String docNo;

    /**
     * 订单创建日期
     */
    @ApiModelProperty("订单创建日期")
    private LocalDateTime createTimeOrder;

    /**
     * 退货单创建日期
     */
    @ApiModelProperty("退货单创建日期")
    private LocalDateTime createTime;

    /**
     * 退货状态
     */
    @ApiModelProperty("退货状态")
    private String docStatus;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String recvContactName;

    /**
     * 客户手机
     */
    @ApiModelProperty("客户手机")
    private String recvContactTel;

    /**
     * 客户收货国家
     */
    @ApiModelProperty("客户收货国家")
    private String recvCountry;

    /**
     * 客户收货省
     */
    @ApiModelProperty("客户收货省")
    private String recvProvince;

    /**
     * 客户收货市
     */
    @ApiModelProperty("客户收货市")
    private String recvCity;

    /**
     * 客户收货县
     */
    @ApiModelProperty("客户收货县")
    private String recvCounty;

    /**
     * 客户收货乡镇街道
     */
    @ApiModelProperty("客户收货乡镇街道")
    private String recvStreet;

    /**
     * 客户收货地址
     */
    @ApiModelProperty("客户收货地址")
    private String recvDetailaddr;

    /**
     * 平台订单编号
     */
    @ApiModelProperty("平台订单编号")
    private String relateDocNo;

    /**
     * 平台订单id
     */
    @ApiModelProperty("平台订单id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;

    /**
     * 买家留言
     */
    @ApiModelProperty("买家留言")
    private String remarkBuyer;

    /**
     * 卖家备注
     */
    @ApiModelProperty("卖家备注")
    private String remarkSeller;

    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @NotEmpty(message = "供应商ID不能为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    @ApiModelProperty("供应商编号")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("是否一件代发")
    private String suppFlag;

    /**
     * 商品id
     */
    @ApiModelProperty("商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    /**
     * 商品编号
     */
    @ApiModelProperty("商品编号")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String itemBrand;

    /**
     * 退货方式
     */
    @ApiModelProperty("退货方式")
    @SysCode(sys = "yst-order", mod = "SO_RETURN_TYPE")
    private String returnType;
    @ApiModelProperty("退货方式 name")
    private String returnTypeName;

    /**
     * 物流单号
     */
    @ApiModelProperty("物流单号")
    private String logisDocNo;

    /**
     * 快递公司
     */
    @ApiModelProperty("快递公司")
    private String logisCarrierName;

    /**
     * 单据类型2
     */
    @ApiModelProperty("单据类型2")
    private String docType2;
    @ApiModelProperty("单据类型2 name")
    private String docType2Name;
}
