package com.elitesland.order.param;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 销售订单行价格(SalSoPrice)实体类
 * @author john.jia
 * @since 2021-05-21 15:34:19
 */

@Data
@ApiModel(value = "sal_so_price", description = "销售订单行价格")
public class SalSoPriceRespDTO implements Serializable {
    private static final long serialVersionUID = 128689816620725593L;
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 销售订单ID
     */
    @ApiModelProperty("销售订单ID")
    private Integer soId;
    /**
     * 销售订单明细ID
     */
    @ApiModelProperty("销售订单明细ID")
    private Integer soDId;
    /**
     * 行号
     */
    @ApiModelProperty("行号")
    private BigDecimal lineNo;
    /**
     * 商品ID
     */
    @ApiModelProperty("商品ID")
    private Integer itemId;
    /**
     * 价格类型 [UDC]SAL:SO_PRICELIST_TYPE
     */
    @ApiModelProperty("价格类型 [UDC]SAL:SO_PRICELIST_TYPE")
    private String pricelistType;
    /**
     * 促销活动ID
     */
    @ApiModelProperty("促销活动ID")
    private Integer promId;
    /**
     * 促销活动明细ID
     */
    @ApiModelProperty("促销活动明细ID")
    private Integer promDId;
    /**
     * 促销活动编号
     */
    @ApiModelProperty("促销活动编号")
    private String promNo;
    /**
     * 价格值
     */
    @ApiModelProperty("价格值")
    private BigDecimal priceVal;
    /**
     * 基于价格
     */
    @ApiModelProperty("基于价格")
    private BigDecimal inPrice;
    /**
     * 价格变化值
     */
    @ApiModelProperty("价格变化值")
    private BigDecimal priceDeltaVal;
    /**
     * 价格变化比例
     */
    @ApiModelProperty("价格变化比例")
    private BigDecimal priceDeltaPercent;
    /**
     * 结果价格
     */
    @ApiModelProperty("结果价格")
    private BigDecimal outPrice;
    /**
     * 刷新时间
     */
    @ApiModelProperty("刷新时间")
    private LocalDateTime refreshTime;
    /**
     * 调整控制码
     */
    @ApiModelProperty("调整控制码")
    private String controlCode;
    /**
     * 租户ID
     */
    @ApiModelProperty("租户ID")
    private Long tenantId;
    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;
    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;
    /**
     * 记录创建者
     */
    @ApiModelProperty("记录创建者")
    private String creator;
    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId;
    /**
     * 记录最后更新者
     */
    @ApiModelProperty("记录最后更新者")
    private String updater;
    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
     * 逻辑删除，0：未删除，1：已删除
     */
    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;
    /**
     * 锁版本
     */
    @ApiModelProperty("锁版本")
    private Integer auditDataVersion;
    @ApiModelProperty("排序号")
    private String sortNo;

    @ApiModelProperty("折扣类型")
    private String discType;

    @ApiModelProperty("折扣编号")
    private String discNo;

    @ApiModelProperty("折扣描述")
    private String discDesc;
    @ApiModelProperty("折扣金额")
    private BigDecimal discAmt;

}
