package com.elitesland.order.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Author: ryan.xu
 * @since 2023/10/8
 */
@Data
public class SalDoDSaveRpcDTO implements Serializable {
    private static final long serialVersionUID = -1679512044096224735L;

    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    private String custCode2;
    /**
     * 主表ID
     */
    @ApiModelProperty("主表ID")
    private Long masId;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    private Long ouId;
    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    private Long buId;
    /**
     * 事业部ID
     */
    @ApiModelProperty("事业部ID")
    private Long bdId;

    /**
     * 行号
     */
    @ApiModelProperty("行号")
    private BigDecimal lineNo;
    /**
     * 行类型 [UDC]SAL:SO_LINE_TYPE
     */
    @ApiModelProperty("行类型 [UDC]SAL:SO_LINE_TYPE")
    private String lineType;
    /**
     * 行状态
     */
    @ApiModelProperty("行状态")
    private String lineStatus;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    private Long whId;
    /**
     * 限定2
     */
    @ApiModelProperty("限定2")
    private String deter2;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    private Long recvWhId;
    /**
     * 收方限定2
     */
    @ApiModelProperty("收方限定2")
    private String recvDeter2;
    /**
     * 货位
     */
    @ApiModelProperty("货位")
    private String whPosi;
    /**
     * 订单配货明细-选中的这一行配货的ID，即SAL_SO_ALLOC.ID
     */
    @ApiModelProperty("订单配货明细")
    private Long soAllocId;
    /**
     * 批号
     */
    @ApiModelProperty("批号")
    private String lotNo;
    /**
     * 客户ID
     */
    @ApiModelProperty("客户ID")
    private Long custId;
    /**
     * 商品ID
     */
    @ApiModelProperty("商品ID")
    private Long itemId;
    /**
     * 商品编号
     */
    @ApiModelProperty("商品编号")
    private String itemCode;
    /**
     * 商品名称
     */
    @ApiModelProperty("商品名称")
    private String itemName;
    /**
     * 商品名称2
     */
    @ApiModelProperty("商品名称2")
    private String itemName2;

    @ApiModelProperty("商品品牌")
    private String itemBrand;
    /**
     * 商品规格
     */
    @ApiModelProperty("商品规格")
    private String itemSpec;
    /**
     * 客户商品编号
     */
    @ApiModelProperty("客户商品编号")
    private String itemCsCode;
    /**
     * 条码
     */
    @ApiModelProperty("条码")
    private String barcode;
    /**
     * 实发数量-默认值0，库存模块回写
     */
    @ApiModelProperty("实发数量")
    private BigDecimal qty;
    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String uom;

    /**
     * 要求发货数量-新建时的默认值是可发货数量， 可手填，不能大于可发货数量，不能<=0，保存后，再打开编辑时就带出上次保存的值，可手改。
     */
    @ApiModelProperty("要求发货数量")
    private BigDecimal demandQty;

    /**
     * 数量2
     */
    @ApiModelProperty("数量2")
    private BigDecimal qty2;
    /**
     * 单位2
     */
    @ApiModelProperty("单位2")
    private String uom2;
    /**
     * 单位转换率
     */
    @ApiModelProperty("单位转换率")
    private BigDecimal uomRatio;
    /**
     * 单位转换率2
     */
    @ApiModelProperty("单位转换率2")
    private BigDecimal uomRatio2;
    /**
     * 装箱要求 [UDC]COM:PACK_DEMAND
     */
    @ApiModelProperty("装箱要求 [UDC]COM:PACK_DEMAND")
    private String packDemand;
    /**
     * 包装数量
     */
    @ApiModelProperty("包装数量")
    private BigDecimal packQty;
    /**
     * 包装单位
     */
    @ApiModelProperty("包装单位")
    private String packUom;
    /**
     * 净重
     */
    @ApiModelProperty("净重")
    private BigDecimal netWeight;
    /**
     * 重量单位
     */
    @ApiModelProperty("重量单位")
    private String weightUom;

    /**
     * 重量转换率 重量单位与主单位
     */
    @ApiModelProperty("重量转换率 重量单位与主单位")
    private BigDecimal weightRatio;

    /**
     * 基价
     */
    @ApiModelProperty("基价")
    private BigDecimal basePrice;
    /**
     * 价格类型
     */
    @ApiModelProperty("价格类型")
    private String priceType;
    /**
     * 含税价格
     */
    @ApiModelProperty("含税价格")
    private BigDecimal price;
    /**
     * 不含税价格
     */
    @ApiModelProperty("不含税价格")
    private BigDecimal netPrice;
    /**
     * 交易单价
     */
    @ApiModelProperty("交易单价")
    private BigDecimal transPrice;
    /**
     * 交易单价税
     */
    @ApiModelProperty("交易单价税")
    private BigDecimal transTaxPrice;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额")
    private BigDecimal amt;
    /**
     * 不含税金额
     */
    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;
    /**
     * 外币含税金额
     */
    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;
    /**
     * 外币不含税金额
     */
    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;
    /**
     * 本币币种
     */
    @ApiModelProperty("本币币种")
    private String homeCurr;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    /**
     * 汇率
     */
    @ApiModelProperty("汇率")
    private BigDecimal currRate;
    /**
     * 成本单价
     */
    @ApiModelProperty("成本单价")
    private BigDecimal costPrice;
    /**
     * 成本金额
     */
    @ApiModelProperty("成本金额")
    private BigDecimal costAmt;
    /**
     * 支付状态
     */
    @ApiModelProperty("支付状态")
    private String payStatus;
    /**
     * 物流状态 [UDC]SAL:LOGIS_STATUS-默认值 0
     */
    @ApiModelProperty("物流状态 [UDC]SAL:LOGIS_STATUS")
    private String logisStatus;
    /**
     * 签收状态-默认值 0
     */
    @ApiModelProperty("签收状态")
    private String confirmStatus;

    /**
     * 要求到货日期
     */
    @ApiModelProperty("要求到货日期")
    private LocalDateTime demandDate;
    /**
     * 已取消数量
     */
    @ApiModelProperty("已取消数量")
    private BigDecimal cancelQty;
    /**
     * 取消时间
     */
    @ApiModelProperty("取消时间")
    private LocalDateTime cancelTime;
    /**
     * 取消原因
     */
    @ApiModelProperty("取消原因")
    private String cancelReason;
    /**
     * 取消用户ID
     */
    @ApiModelProperty("取消用户ID")
    private Long cancelUserId;
    /**
     * 已退货数量
     */
    @ApiModelProperty("已退货数量")
    private BigDecimal returnedQty;
    /**
     * 拣货数量
     */
    @ApiModelProperty("拣货数量")
    private BigDecimal pickedQty;

    /**
     * 订单要求发货数
     */
    @ApiModelProperty("订单要求发货数")
    private BigDecimal soQty;
    /**
     * 根ID
     */
    @ApiModelProperty("根ID")
    private Long rootId;
    /**
     * 关联单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    private String relateDocCls;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据明细ID
     */
    @ApiModelProperty("关联单据明细ID")
    private Long relateDocDid;
    /**
     * 关联单据行号
     */
    @ApiModelProperty("关联单据行号")
    private BigDecimal relateDocLineno;
    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    private String relateDoc2Cls;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID
     */
    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;
    /**
     * 关联单据2编号
     */
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    /**
     * 关联单据2明细ID
     */
    @ApiModelProperty("关联单据2明细ID")
    private Long relateDoc2Did;
    /**
     * 关联单据2行号
     */
    @ApiModelProperty("关联单据2行号")
    private BigDecimal relateDoc2Lineno;
    /**
     * 体积-QTY* SINGLE_VOLUME
     */
    @ApiModelProperty("体积")
    private BigDecimal volume;

    /**
     * 毛重-QTY* SINGLE_GROSS_WEIGHT
     */
    @ApiModelProperty("毛重")
    private BigDecimal grossWeight;

    /**
     * 单个体积
     */
    @ApiModelProperty("单个体积")
    private BigDecimal singleVolume;
    /**
     * 已签收数量-默认值 0
     */
    @ApiModelProperty("已签收数量")
    private BigDecimal confirmQty;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 签收日期
     */
    @ApiModelProperty("签收日期")
    private LocalDateTime confirmTime;
    /**
     * 签收用户ID
     */
    @ApiModelProperty("签收用户ID")
    private Long confirmUserId;
    /**
     * 签收人
     */
    @ApiModelProperty("签收人")
    private String confirmName;

    /**
     * 拒收中数量
     */
    @ApiModelProperty("拒收中数量")
    private BigDecimal rejectingQty;
    /**
     * 已拒收数量
     */
    @ApiModelProperty("已拒收数量")
    private BigDecimal rejectQty;
    @ApiModelProperty("来源单据明细ID ")
    private Long rootDocDId;

    @ApiModelProperty("来源单据行号 ")
    private Long rootDocLineno;

    /**
     * 关联单据类别 来源采购订单等。[UDC]COM:DOC_CLS
     */
    @ApiModelProperty("来源单据类别 ")
    private String rootDocCls;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String rootDocType;
    /**
     * 关联单据ID
     */
    @ApiModelProperty("关联单据ID")
    private Long rootDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String rootDocNo;

    @ApiModelProperty("操作人id")
    private Long createUserId;
    /**
     * 记录创建者
     */
    @ApiModelProperty("记录创建者")
    private String creator;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId;
    /**
     * 记录最后更新者
     */
    @ApiModelProperty("记录最后更新者")
    private String updater;

    @ApiModelProperty("修改时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;
}
