package com.elitesland.order.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 销售发货和退货入库明细(SalDoD)查询结果对象
 *
 * @author fred
 * @since 2021-05-14 14:20:53
 */

@Data
@ApiModel(value = "SalDoDRespVO", description = "销售发货和退货入库明细")
public class SalDoDetailRespDTO implements Serializable {

    private static final long serialVersionUID = 7123490782098293954L;
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    private String custCode2;
    /**
     * 主表ID
     */
    @ApiModelProperty("主表ID")
    private Long masId;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    private Long ouId;
    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    private Long buId;
    /**
     * 事业部ID
     */
    @ApiModelProperty("事业部ID")
    private Long bdId;
    /**
     * 利润中心ID
     */
    @ApiModelProperty("利润中心ID")
    private Long pcId;
    /**
     * 行号
     */
    @ApiModelProperty("行号")
    private BigDecimal lineNo;
    /**
     * 行类型 [UDC]SAL:SO_LINE_TYPE
     */
    @ApiModelProperty("行类型 [UDC]SAL:SO_LINE_TYPE")
    private String lineType;
    private String lineTypeName;
    /**
     * 行状态
     */
    @ApiModelProperty("行状态")
    private String lineStatus;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    private Long whId;
    /**
     * 仓库名称
     */
    @ApiModelProperty("仓库名称")
    private String whName;
    /**
     * 限定1
     */
    @ApiModelProperty("限定1")
    private String deter1;
    /**
     * 限定2
     */
    @ApiModelProperty("限定2")
    private String deter2;
    /**
     * 限定3
     */
    @ApiModelProperty("限定3")
    private String deter3;
    /**
     * 限定4
     */
    @ApiModelProperty("限定4")
    private String deter4;
    /**
     * 限定5
     */
    @ApiModelProperty("限定5")
    private String deter5;
    /**
     * 限定6
     */
    @ApiModelProperty("限定6")
    private String deter6;
    /**
     * 限定7
     */
    @ApiModelProperty("限定7")
    private String deter7;
    /**
     * 限定8
     */
    @ApiModelProperty("限定8")
    private String deter8;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    private Long recvWhId;
    /**
     * 收方限定1
     */
    @ApiModelProperty("收方限定1")
    private String recvDeter1;
    /**
     * 收方限定2
     */
    @ApiModelProperty("收方限定2")
    private String recvDeter2;
    /**
     * 收方限定3
     */
    @ApiModelProperty("收方限定3")
    private String recvDeter3;
    /**
     * 收方限定4
     */
    @ApiModelProperty("收方限定4")
    private String recvDeter4;

    /**
     * 功能区名称
     */
    @ApiModelProperty("功能区名称")
    private String deter2Name;


    /**
     * 货位
     */
    @ApiModelProperty("货位")
    private String whPosi;
    /**
     * 订单配货明细-选中的这一行配货的ID，即SAL_SO_ALLOC.ID
     */
    @ApiModelProperty("订单配货明细")
    private Long soAllocId;
    /**
     * 批号
     */
    @ApiModelProperty("批号")
    private String lotNo;
    /**
     * 客户ID
     */
    @ApiModelProperty("客户ID")
    private Long custId;
    /**
     * 商品ID
     */
    @ApiModelProperty("商品ID")
    private Long itemId;
    /**
     * 商品编号
     */
    @ApiModelProperty("商品编号")
    private String itemCode;
    /**
     * 商品名称
     */
    @ApiModelProperty("商品名称")
    private String itemName;
    /**
     * 商品名称2
     */
    @ApiModelProperty("商品名称2")
    private String itemName2;
    /**
     * 商品规格
     */
    @ApiModelProperty("商品规格")
    private String itemSpec;
    /**
     * 客户商品编号
     */
    @ApiModelProperty("客户商品编号")
    private String itemCsCode;
    /**
     * SPUID
     */
    @ApiModelProperty("SPUID")
    private Long spuId;
    /**
     * SPU编号
     */
    @ApiModelProperty("SPU编号")
    private String spuCode;
    /**
     * SPU名称
     */
    @ApiModelProperty("SPU名称")
    private String spuName;
    /**
     * 条码
     */
    @ApiModelProperty("条码")
    private String barcode;
    /**
     * 实发数量-默认值0，库存模块回写
     */
    @ApiModelProperty("实发数量")
    private BigDecimal qty;
    /**
     * 订单数量-数量与单位合并显示，格式是10台
     */
    @ApiModelProperty("订单数量")
    private BigDecimal saleQty;
    @ApiModelProperty("赠品类型")
    private String giftType;
    @ApiModelProperty("赠品来源行号")
    private BigDecimal giftRelateNo;
    @ApiModelProperty("是否护杠物料")
    private String cat3;
    /**
     * 退货数量
     */
    @ApiModelProperty("退货数量")
    private BigDecimal returnQty;
    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String uom;
    private String uomName;

    @ApiModelProperty("库存客户编码")
    private String invCustCode;

    /**
     * 分配数量
     */
    @ApiModelProperty("分配数量")
    private BigDecimal allocQty;
    /**
     * 已出库数量
     */
    @ApiModelProperty("已出库数量")
    private BigDecimal shippedQty;
    /**
     * 可发货数量
     */
    @ApiModelProperty("可发货数量")
    private BigDecimal unShippedQty;

    /**
     * 要求发货数量-新建时的默认值是可发货数量， 可手填，不能大于可发货数量，不能<=0，保存后，再打开编辑时就带出上次保存的值，可手改。
     */
    @ApiModelProperty("要求发货数量")
    private BigDecimal demandQty;
    /**
     * 单个毛重
     */
    @ApiModelProperty("单个毛重")
    private BigDecimal singleGrossWeight;

    /**
     * 毛重-QTY* SINGLE_GROSS_WEIGHT
     */
    @ApiModelProperty("毛重")
    private BigDecimal grossWeight;

    /**
     * 数量2
     */
    @ApiModelProperty("数量2")
    private BigDecimal qty2;
    /**
     * 单位2
     */
    @ApiModelProperty("单位2")
    private String uom2;
    /**
     * 单位转换率
     */
    @ApiModelProperty("单位转换率")
    private BigDecimal uomRatio;
    /**
     * 单位转换率2
     */
    @ApiModelProperty("单位转换率2")
    private BigDecimal uomRatio2;
    /**
     * 装箱要求 [UDC]COM:PACK_DEMAND
     */
    @ApiModelProperty("装箱要求 [UDC]COM:PACK_DEMAND")
    private String packDemand;
    /**
     * 包装数量
     */
    @ApiModelProperty("包装数量")
    private BigDecimal packQty;
    /**
     * 包装单位
     */
    @ApiModelProperty("包装单位")
    private String packUom;
    /**
     * 净重
     */
    @ApiModelProperty("净重")
    private BigDecimal netWeight;
    /**
     * 重量单位
     */
    @ApiModelProperty("重量单位")
    private String weightUom;
    private String weightUomName;

    /**
     * 重量转换率 重量单位与主单位
     */
    @ApiModelProperty("重量转换率 重量单位与主单位")
    private BigDecimal weightRatio;
    /**
     * 体积-QTY* SINGLE_VOLUME
     */
    @ApiModelProperty("体积")
    private BigDecimal volume;
    /**
     * 体积单位
     */
    @ApiModelProperty("体积单位")
    private String volumeUom;
    private String volumeUomName;

    /**
     * 基价
     */
    @ApiModelProperty("基价")
    private BigDecimal basePrice;
    /**
     * 价格类型
     */
    @ApiModelProperty("价格类型")
    private String priceType;
    /**
     * 含税价格
     */
    @ApiModelProperty("含税价格")
    private BigDecimal price;
    /**
     * 不含税价格
     */
    @ApiModelProperty("不含税价格")
    private BigDecimal netPrice;
    /**
     * 交易单价
     */
    @ApiModelProperty("交易单价")
    private BigDecimal transPrice;
    /**
     * 交易单价税
     */
    @ApiModelProperty("交易单价税")
    private BigDecimal transTaxPrice;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额")
    private BigDecimal amt;
    /**
     * 不含税金额
     */
    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;
    /**
     * 外币含税金额
     */
    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;
    /**
     * 外币不含税金额
     */
    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;
    /**
     * 本币币种
     */
    @ApiModelProperty("本币币种")
    private String homeCurr;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    /**
     * 汇率
     */
    @ApiModelProperty("汇率")
    private BigDecimal currRate;
    /**
     * 成本单价
     */
    @ApiModelProperty("成本单价")
    private BigDecimal costPrice;
    /**
     * 成本金额
     */
    @ApiModelProperty("成本金额")
    private BigDecimal costAmt;
    /**
     * 支付状态
     */
    @ApiModelProperty("支付状态")
    private String payStatus;
    /**
     * 物流状态 [UDC]SAL:LOGIS_STATUS-默认值 0
     */
    @ApiModelProperty("物流状态 [UDC]SAL:LOGIS_STATUS")
    private String logisStatus;
    /**
     * 签收状态-默认值 0
     */
    @ApiModelProperty("签收状态")
    private String confirmStatus;
    private String confirmStatusName;

    /**
     * 要求到货日期
     */
    @ApiModelProperty("要求到货日期")
    private LocalDateTime demandDate;
    /**
     * 已取消数量
     */
    @ApiModelProperty("已取消数量")
    private BigDecimal cancelQty;
    /**
     * 取消时间
     */
    @ApiModelProperty("取消时间")
    private LocalDateTime cancelTime;
    /**
     * 取消原因
     */
    @ApiModelProperty("取消原因")
    private String cancelReason;
    /**
     * 取消用户ID
     */
    @ApiModelProperty("取消用户ID")
    private Long cancelUserId;
    /**
     * 已退货数量
     */
    @ApiModelProperty("已退货数量")
    private BigDecimal returnedQty;
    /**
     * 拣货数量
     */
    @ApiModelProperty("拣货数量")
    private BigDecimal pickedQty;
    /**
     * 剩余效期天数
     */
    @ApiModelProperty("剩余效期天数")
    private Integer untilExpireDays;
    /**
     * 新鲜度 [UDC]COM:FRESS_TYPE
     */
    @ApiModelProperty("新鲜度 [UDC]COM:FRESS_TYPE")
    private String fressType;
    /**
     * 是否超允收期
     */
    @ApiModelProperty("是否超允收期")
    private String aapFlag;
    /**
     * 订单要求发货数
     */
    @ApiModelProperty("订单要求发货数")
    private BigDecimal soQty;
    /**
     * 根ID
     */
    @ApiModelProperty("根ID")
    private Long rootId;
    /**
     * 关联单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    private String relateDocCls;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据明细ID
     */
    @ApiModelProperty("关联单据明细ID")
    private Long relateDocDid;
    /**
     * 关联单据行号
     */
    @ApiModelProperty("关联单据行号")
    private BigDecimal relateDocLineno;
    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    private String relateDoc2Cls;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID
     */
    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;
    /**
     * 关联单据2编号
     */
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    /**
     * 关联单据2明细ID
     */
    @ApiModelProperty("关联单据2明细ID")
    private Long relateDoc2Did;
    /**
     * 关联单据2行号
     */
    @ApiModelProperty("关联单据2行号")
    private BigDecimal relateDoc2Lineno;
    /**
     * 外部单据公司
     */
    @ApiModelProperty("外部单据公司")
    private String outerOu;
    /**
     * 外部单据类型
     */
    @ApiModelProperty("外部单据类型")
    private String outerType;
    /**
     * 外部单据编号
     */
    @ApiModelProperty("外部单据编号")
    private String outerNo;
    /**
     * 外部单据行号
     */
    @ApiModelProperty("外部单据行号")
    private String outerLineno;
    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String itemBrand;
    private String itemBrandName;
    /**
     * 是否需要服务
     */
    @ApiModelProperty("是否需要服务")
    private String needServiceFlag;
    /**
     * 是否安装收费
     */
    @ApiModelProperty("是否安装收费")
    private String serviceFeeFlag;
    /**
     * 单个体积
     */
    @ApiModelProperty("单个体积")
    private BigDecimal singleVolume;
    /**
     * 已签收数量-默认值 0
     */
    @ApiModelProperty("已签收数量")
    private BigDecimal confirmQty;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 单个净重
     */
    @ApiModelProperty("单个净重")
    private BigDecimal singleNetWeight;
    /**
     * 接口状态 用于生成一件代发PO时
     */
    @ApiModelProperty("接口状态 用于生成一件代发PO时")
    private String intfStatus;
    /**
     * 接口时间 用于生成一件代发PO时
     */
    @ApiModelProperty("接口时间 用于生成一件代发PO时")
    private LocalDateTime intfTime;

    /**
     * 签收日期
     */
    @ApiModelProperty("签收日期")
    private LocalDateTime confirmTime;
    /**
     * 签收用户ID
     */
    @ApiModelProperty("签收用户ID")
    private Long confirmUserId;
    /**
     * 签收人
     */
    @ApiModelProperty("签收人")
    private String confirmName;
    /**
     * 仓库合作伙伴编号,如果是网格个人仓，传网格员员工编号
     */
    @ApiModelProperty("仓库合作伙伴编号,如果是网格个人仓，传网格员员工编号")
    private String whPCode;
    /**
     * 仓库合作伙伴类型，如果是网格个人仓，传EMP
     */
    @ApiModelProperty("仓库合作伙伴类型，如果是网格个人仓，传EMP")
    private String whPType;
    /**
     * 已取消数量（订单）
     */
    @ApiModelProperty("已取消数量（订单）")
    private BigDecimal saleCancelQty;

    /**
     * 拒收中数量
     */
    @ApiModelProperty("拒收中数量")
    private BigDecimal rejectingQty;
    /**
     * 已拒收数量
     */
    @ApiModelProperty("已拒收数量")
    private BigDecimal rejectQty;

    @ApiModelProperty("行标记 区分主件/子件")
    private String lineFlag;

    @ApiModelProperty("主件id")
    private Long pId;

    @ApiModelProperty("主件行号")
    private BigDecimal pNo;

    @ApiModelProperty("商品编号2")
    private String itemCode2;

    @ApiModelProperty("商品编号3")
    private String itemCode3;

    @ApiModelProperty("商品名称3")
    private String itemName3;

    @ApiModelProperty("商品简称")
    private String itemAbbr;

    @ApiModelProperty("商品类型2 [UDC]ITM:ITEM_TYPE2")
    private String itemType2;
    private String itemType2Name;

    @ApiModelProperty("商品类型3 [UDC]ITM:ITEM_TYPE3")
    private String itemType3;
    private String itemType3Name;

    @ApiModelProperty("商品类型4 [UDC]ITM:ITEM_TYPE4")
    private String itemType4;
    private String itemType4Name;

    @ApiModelProperty("商品类型5 [UDC]ITM:ITEM_TYPE5")
    private String itemType5;
    private String itemType5Name;

    @ApiModelProperty("系列 [UDC]ITM:ITEM_GROUP")
    private String itemGroup;

    @ApiModelProperty("品项组2 [UDC]ITM:ITEM_GROUP2")
    private String itemGroup2;

    @ApiModelProperty("品项组3 [UDC]ITM:ITEM_GROUP3")
    private String itemGroup3;

    @ApiModelProperty("产地 [UDC]ITM:ORIGIN")
    private String origin;

    @ApiModelProperty("关联明细ID")
    private Long relateDid;

    @ApiModelProperty("关联明细2ID")
    private Long relate2Did;

    @ApiModelProperty("退货审核数量")
    private BigDecimal returnApprQty;

    @ApiModelProperty("退货审核金额")
    private BigDecimal returnApprAmt;

    @ApiModelProperty("退货开票金额")
    private BigDecimal returninvAmt;

    @ApiModelProperty("发运基地ID")
    private Long desId;

    @ApiModelProperty("系列 [UDC]ITM:ITEM_GROUP")
    private String itemCatCode;


    @ApiModelProperty("全国统一价")
    private BigDecimal unifyPrice;

    @ApiModelProperty("护杠价格")
    private BigDecimal guardBarPrice;

    @ApiModelProperty("运输加价")
    private BigDecimal transportPrice;

    @ApiModelProperty("调拨加价")
    private BigDecimal allocatePrice;

    @ApiModelProperty("区域加价")
    private BigDecimal regionPrice;

    @ApiModelProperty("包装加价")
    private BigDecimal packPrice;
    @ApiModelProperty("直降")
    private BigDecimal directDescent;
    @ApiModelProperty("次返")
    private BigDecimal secondReturn;

    @ApiModelProperty("追加返利")
    private BigDecimal addRebate;

    @ApiModelProperty("月返")
    private BigDecimal mouthRebate;
    @ApiModelProperty("统筹费用")
    private BigDecimal overallCost;
    @ApiModelProperty("追加统筹")
    private BigDecimal addOverall;

    @ApiModelProperty("政策备注")
    private String policyRemark;
    @ApiModelProperty("其他备注")
    private String otherRemark;
    @ApiModelProperty("其他备注")
    private String otherRemark2;
    @ApiModelProperty("是否电池配比")
    private Boolean chargeRatio;

    @ApiModelProperty("是否月返")
    private Boolean ifMouthRebate;

    @ApiModelProperty("是否年返")
    private Boolean ifYearRebate;

    @ApiModelProperty("政策编号")
    private String policyNo;
    /**
     * SPU图片
     */
    @ApiModelProperty("SPU图片code")
    private String spuImageFileCode;
    /**
     * 商品类型
     */
    @ApiModelProperty("商品类型")
    private String itemType;
    private String itemTypeName;
    /**
     * 批次号
     */
    @ApiModelProperty("批次号")
    private String batchNo;
    /**
     * 仓库编码
     */
    @ApiModelProperty("仓库编码")
    private String whCode;
    /**
     * 定位
     */
    @ApiModelProperty("定位")
    private String itemPosit;

    @ApiModelProperty("操作人id")
    private Long createUserId;
    /**
     * 记录创建者
     */
    @ApiModelProperty("记录创建者")
    private String creator;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId;
    /**
     * 记录最后更新者
     */
    @ApiModelProperty("记录最后更新者")
    private String updater;

    @ApiModelProperty("修改时间")
    private LocalDateTime modifyTime;


    /**
     * 未对账数量
     */
    @ApiModelProperty("未对账数量")
    private BigDecimal noSoaQty;

    /**
     * 对账中数量
     */
    @ApiModelProperty("对账中数量")
    private BigDecimal soaingQty;

    /**
     * 已对账数量
     */
    @ApiModelProperty("已对账数量")
    private BigDecimal soaedQty;


    @ApiModelProperty("对账状态")
    private String soaStatus;

    private String docNo;

    private String docStatus;
    /**
     * 差异数量
     */
    @ApiModelProperty("差异数量")
    private BigDecimal diffQty;

    /**
     * 主客户编码
     */
    @ApiModelProperty("主客户编码")
    private String preCustCode;


    /**
     * 客户渠道
     */
    @ApiModelProperty("客户渠道")
    private String saleChannel;

}