package com.elitesland.order.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author evin.dong
 * @Date 2021-06-30-1:32 下午
 * @Description 订单收款结算商品细表
 */
@Data
public class SalReceiptSettleItemDTO implements Serializable {

    private static final long serialVersionUID = -2338962596448571662L;
    @ApiModelProperty(value = "唯一标识")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "表头id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    @ApiModelProperty(value = "行号")
    private Integer lineNo;

    @ApiModelProperty(value = "订单行号")
    private Integer SoLineNo;

    @ApiModelProperty(value = "商品品类")
    private String itemCat;

    @ApiModelProperty(value = "商品分类全路径名称")
    private List<String> itemCatName;

    @ApiModelProperty(value = "商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty(value = "商品编号")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "财务分类")
    private String finCat;

    @ApiModelProperty(value = "税率编号")
    private String taxRateNo;

    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "应收款金额")
    private BigDecimal apAmt;

    @ApiModelProperty(value = "购物卡金额")
    private BigDecimal cardAmt;

    @ApiModelProperty(value = "优惠券金额")
    private BigDecimal CouponAmt;

    @ApiModelProperty(value = "提货券金额")
    private BigDecimal giftAmt;

    @ApiModelProperty(value = "使用积分金额")
    private BigDecimal usepointAmt;

    @ApiModelProperty(value = "收款金额")
    private BigDecimal receiptAmt;

    @ApiModelProperty(value = "收款方式 [UDC]COM:PAY_METHOD")
    private String receiptMethod;
    private String receiptMethodName;


    @ApiModelProperty(value = "收款公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long receiptOuId;

    @ApiModelProperty(value = "收款公司编号")
    private String receiptOuCode;

    @ApiModelProperty(value = "收款公司名称")
    private String receiptOuName;

    @ApiModelProperty(value = "收款税额")
    private BigDecimal receiptTax;

    @ApiModelProperty(value = "业务类型")
    private String busiType;
}
