package com.elitesland.order.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 销售发货和退货入库明细(SalDoD)查询结果对象
 *
 * @author Unicorn
 * @since 2024-05-09 14:20:53
 */

@Data
@ApiModel(value = "SalDoDQueryRespDTO", description = "销售发货和退货入库明细")
public class SalDoDQueryRespDTO implements Serializable {
    private static final long serialVersionUID = -3532580281711486459L;


    /**
    * 记录唯一ID
    */    
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
    * 主表ID
    */
    @ApiModelProperty("主表ID")
    private Long masId;
    /**
    * 行号
    */    
    @ApiModelProperty("行号")
    private BigDecimal lineNo;
    /**
    * 商品ID
    */    
    @ApiModelProperty("商品ID")
    private Long itemId;

    /**
     * 商品code
     */
    @ApiModelProperty("商品code")
    private String itemCode;

    /**
     * 商品名称
     */
    @ApiModelProperty("商品名称")
    private String itemName;

    /**
    * 商品规格
    */    
    @ApiModelProperty("商品规格")
    private String itemSpec;

    /**
     * 基准价
     */
    @ApiModelProperty("基准价")
    private BigDecimal basePrice;

    /**
     * 单价
     */
    @ApiModelProperty("单价")
    private BigDecimal price;

    /**
    * 实发数量-默认值0，库存模块回写
    */    
    @ApiModelProperty("实发数量")
    private BigDecimal qty;

    @ApiModelProperty("数量2 订单数量")
    private  BigDecimal qty2;

    /**
    * 单位
    */    
    @ApiModelProperty("单位")
    private String uom;
    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额")
    private BigDecimal amt;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;

    /**
     * 返利冲抵金额:发货单签收数量/订单明细行数量*订单明细行返利支付金额
     */
    @ApiModelProperty("返利冲抵金额")
    private BigDecimal flDeductionAmt;

    /**
     * 订单明细行返利支付金额
     */
    private BigDecimal receiptFlAmt;

    /**
     * 已签收数量-默认值 0
     */
    @ApiModelProperty("已签收数量")
    private BigDecimal confirmQty;
    /**
     * 记录根据销售单位的签收数量
     */
    @ApiModelProperty("记录根据销售单位的签收数量")
    private BigDecimal confirmQty2;
    /**
     * 已签收金额
     */
    @ApiModelProperty("已签收金额")
    private BigDecimal confirmAmt;
}
