package com.elitesland.order.param;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * .
 *
 * @author evin.dong
 * @date 2021-06-16
 */
@ApiModel(description = "订单收款明细保存参数对象")
@Data
public class SalSoInvSaveDTO implements Serializable {


    private static final long serialVersionUID = 1302361084821561052L;
    /**
     * id
     */
    @ApiModelProperty(value = "id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 销售订单ID
     */
    @ApiModelProperty(value = "销售订单ID", required = true)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long soId;
    /**
     * 销售订单号
     */
    @ApiModelProperty(value = "销售订单号")
    private String soNo;
    /**
     * 销售订单明细ID
     */
    @ApiModelProperty(value = "销售订单明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long soDId;
    /**
     * 行号
     */
    @ApiModelProperty(value = "行号")
    private String soLineNo;
    /**
     * 发货单ID
     */
    @ApiModelProperty(value = "发货单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long doId;
    /**
     * 发货单明细ID
     */
    @ApiModelProperty(value = "发货单明细ID")
    private Long doDId;
    /**
     * 开票日期
     */
    @ApiModelProperty(value = "开票日期",required = true)
    private String invDate;
    /**
     * 开票金额
     */
    @ApiModelProperty(value = "开票金额",required = true)
    private BigDecimal invAmt;
    /**
     * 开票税额
     */
    @ApiModelProperty(value = "开票税额",required = true)
    private BigDecimal taxAmt;
    /**
     * 税率编号
     */
    @ApiModelProperty(value = "税率编号")
    private String taxRateNo;
    /**
     * 税率
     */
    @ApiModelProperty(value = "税率",required = true)
    private BigDecimal taxRate;
    /**
     * 购方名称
     */
    @ApiModelProperty(value = "购方名称")
    private String invTitle;
    /**
     * 税号
     */
    @ApiModelProperty(value = "税号")
    private String taxerNo;
    /**
     * 发票类型
     */
    @ApiModelProperty(value = "发票类型")
    private String invType;
    /**
     * 发票代码
     */
    @ApiModelProperty(value = "发票代码")
    private String invType2;
    /**
     * 发票号码
     */
    @ApiModelProperty(value = "发票号码")
    private String invNo;
    /**
     * 本次开票数量
     */
    @ApiModelProperty(value = "本次开票数量")
    private BigDecimal invQty;
    /**
     * 创建人ID
     */
    @ApiModelProperty(value = "创建人ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;
    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private String createTime;
}
