package com.elitesland.order.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 销售发货和退货入库(SalDo)查询结果对象
 *
 * @author Unicorn
 * @since 2024-05-09 11:32:18
 */

@Data
@ApiModel(value = "SalDoQueryRespDTO", description = "销售发货和退货入库")
public class SalDoQueryRespDTO implements Serializable {

    private static final long serialVersionUID = -5443194357280227502L;

    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;

    /**
     * 发货单编号
     */
    @ApiModelProperty("发货单编号")
    private String docNo;
    /**
     * 发货单日期
     */
    @ApiModelProperty("发货单日期")
    private LocalDateTime docDate;
    /**
    * 发货时间
    */
    @ApiModelProperty("发货时间")
    private LocalDateTime docTime;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    private Long ouId;

    /**
     * 公司code
     */
    @ApiModelProperty("公司code")
    private String ouCode;

    /**
     * 公司名称
     */
    @ApiModelProperty("公司名称")
    private String ouName;

    /**
     * 子客户id
     */
    @ApiModelProperty("子客户id")
    private Long custId;

    /**
     * 子客户编码
     */
    @ApiModelProperty("子客户编码")
    private String custCode;

    /**
     * 子客户名称
     */
    @ApiModelProperty("子客户名称")
    private String custName;

    /**
     * 主客户编码
     */
    @ApiModelProperty("主客户编码")
    private String preCustCode;

    /**
     * 主客户名称
     */
    @ApiModelProperty("主客户名称")
    private String preCustName;

    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;

    /**
     * 供应商id
     */
    @ApiModelProperty("供应商id")
    private Long suppId;
    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
     * 单据状态 [UDC]SAL:DO_STATUS
     */
    @ApiModelProperty("单据状态 [UDC]SAL:DO_STATUS")
    private String docStatus;
    /**
     * 单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("单据类别 [UDC]COM:DOC_CLS")
    private String docCls;
    /**
     * 是否供应商代发
     */
    @ApiModelProperty("是否供应商代发")
    private String suppFlag;
    /**
     * 单据类型 [UDC]SAL:DO_TYPE2
     */
    @ApiModelProperty("单据类型 [UDC]SAL:DO_TYPE2")
    private String docType2;
    /**
     * 关联单据ID So_ID，退货为退货订单
     */
    @ApiModelProperty("关联单据ID So_ID，退货为退货订单")
    private Long relateDocId;
    /**
     * 销售单号，退货为退货订单
     */
    @ApiModelProperty("销售单号，退货为退货订单")
    private String relateDocNo;

    /**
     * 销售单号，退货为退货订单类型
     */
    @ApiModelProperty("销售单号，退货为退货订单类型")
    private String relateDocType;

    /**
     * 关联单据ID So_ID，退货为原始订单
     */
    @ApiModelProperty("关联单据ID So_ID，退货为原始订单")
    private Long relateDoc2Id;
    /**
     * 销售单号，退货为原始订单
     */
    @ApiModelProperty("销售单号，退货为原始订单")
    private String relateDoc2No;

    /**
     * 签收日期
     */
    @ApiModelProperty("签收日期")
    private LocalDateTime confirmTime;
    /**
     * 订单日期
     */
    @ApiModelProperty("订单日期")
    private LocalDateTime soTime;

    /**
     * 发货单明细信息
     */
    @ApiModelProperty("发货单明细信息")
    private List<SalDoDQueryRespDTO> salDoDQueryRespDTOList;
}