package com.elitesland.order.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@ApiModel(value = "SalSoDRespDTO", description = "销售订单明细查询")
public class SalSoDRespDTO implements Serializable {
    private static final long serialVersionUID = 264015312312070899L;
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;

    private String docNo;
    private String docType;
    private BigDecimal freightFee;
    private String docTypeName;
    @ApiModelProperty("优惠券金额")
    private BigDecimal couponAmt;

    @ApiModelProperty("购物卡金额")
    private BigDecimal cardAmt;
    @ApiModelProperty("提货券金额")
    private BigDecimal giftAmt;
    private BigDecimal payingAmt;
    @ApiModelProperty("使用积分金额")
    private BigDecimal usePointAmt;

    @ApiModelProperty("发放积分金额")
    private BigDecimal getPointAmt;
    private BigDecimal invedAmt;
    private BigDecimal invingAmt;
    private BigDecimal noinvAmt;
    private BigDecimal noinvQty;
    private BigDecimal invedQty;
    private BigDecimal invingQty;
    /**
     * 主表ID
     */
    @ApiModelProperty("主表ID")
    private Long masId;
    private String suppName;
    private String pickingStatus;
    private String pickingStatusName;
    @ApiModelProperty("退货状态")
    private String returnStatus;
    private String returnStatusName;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    private Long ouId;
    /**
     * 销售公司Name
     */
    @ApiModelProperty("销售公司Name")
    private String ouName;
    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    private Long buId;
    /**
     * 销售组织name
     */
    @ApiModelProperty("销售组织name")
    private String buName;
    /**
     * 行号
     */
    @ApiModelProperty("行号")
    private BigDecimal lineNo;
    @ApiModelProperty("行类型")
    private String lineType;
    @ApiModelProperty("行类型 名称")
    private String lineTypeName;
    private String lineTypeList;
    private String allocType;
    @ApiModelProperty("服务工单策略 1=需要生成服务工单。0=不需要生成服务工单。生成服务工单时会用到这个值。")
    private String servicePolicy;
    @ApiModelProperty("价格策略 1=有价格。0=0价格。0价格的在创建和编辑订单时，价格不需要获取，直接就是0，且不能修改")
    private String pricePolicy;
    /**
     * 价格修订策略
     * 0不能改
     * 1能改
     */
    @ApiModelProperty("价格修订策略0不能改 1能改")
    private String  priceModifyPolicy;
    /**
     * 金额策略
     * 0=数量*单价
     * 1=自由填写
     */
    @ApiModelProperty("金额策略0=数量*单价,1=自由填写")
    private String  amtPolicy;
    /**
     * 行状态 [UDC]SAL:SO_LINE_STATUS
     */
    @ApiModelProperty("行状态 [UDC]SAL:SO_LINE_STATUS")
    private String lineStatus;
    private String lineStatusName;
    private String logisStatusName;
    private String confirmStatusName;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    private Long whId;
    /**
     * 收方仓库ID
     */
    @ApiModelProperty("收方仓库ID")
    private Long recvWhId;
    /**
     * 收方限定1
     */
    @ApiModelProperty("收方限定1")
    private String recvDeter1;
    /**
     * 收方限定2
     */
    @ApiModelProperty("收方限定2")
    private String recvDeter2;
    /**
     * 限定1
     */
    @ApiModelProperty("限定1")
    private String deter1;
    /**
     * 限定2
     */
    @ApiModelProperty("限定2")
    private String deter2;


    private String deter2Name;
    /**
     * 库位
     */
    @ApiModelProperty("库位")
    private String whLoc;
    /**
     * 库位
     */
    @ApiModelProperty("库位")
    private String whLocName;
    /**
     * 货位
     */
    @ApiModelProperty("货位")
    private String whPosi;
    /**
     * 客户ID
     */
    @ApiModelProperty("客户ID")
    private Long custId;
    /**
     * 商品ID
     */
    @ApiModelProperty("商品ID")
    private Long itemId;
    /**
     * 商品编号
     */
    @ApiModelProperty("商品编号")
    private String itemCode;
    /**
     * 商品名称
     */
    @ApiModelProperty("商品名称")
    private String itemName;
    /**
     * 商品名称2
     */
    @ApiModelProperty("商品名称2")
    private String itemName2;
    /**
     * 商品规格
     */
    @ApiModelProperty("商品规格")
    private String itemSpec;
    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String itemBrand;
    private String brandName;
    /**
     * 客户商品编号
     */
    @ApiModelProperty("客户商品编号")
    private String itemCsCode;
    /**
     * SPUID
     */
    @ApiModelProperty("SPUID")
    private Long spuId;
    /**
     * SPU编号
     */
    @ApiModelProperty("SPU编号")
    private String spuCode;
    /**
     * SPU名称
     */
    @ApiModelProperty("SPU名称")
    private String spuName;
    /**
     * 条码
     */
    @ApiModelProperty("条码")
    private String barcode;
    /**
     * 是否供应商代发
     */
    @ApiModelProperty("是否供应商代发")
    private String suppFlag;
    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    private Long suppId;
    /**
     * 运输方式 [UDC]COM:TP_TYPE
     */
    @ApiModelProperty("运输方式 [UDC]COM:TP_TYPE")
    private String transType;

    /**
     * 承运商
     */
    @ApiModelProperty("承运商")
    private String carrier;
    /**
     * 批号
     */
    @ApiModelProperty("批号")
    private String lotNo;
    /**
     * 数量
     */
    @ApiModelProperty("数量")
    private BigDecimal qty;
    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String uom;
    private String uomName;
    private String itemCateCode;
    /**
     * 单个毛重
     */
    @ApiModelProperty("单个毛重")
    private BigDecimal singleGrossWeight;
    private String weightUomName;
    private String volumeUomName;
    /**
     * 数量2
     */
    @ApiModelProperty("数量2")
    private BigDecimal qty2;
    /**
     * 单位2
     */
    @ApiModelProperty("单位2")
    private String uom2;
    /**
     * 单位转换率
     */
    @ApiModelProperty("单位转换率")
    private BigDecimal uomRatio;
    /**
     * 单位转换率2
     */
    @ApiModelProperty("单位转换率2")
    private BigDecimal uomRatio2;
    /**
     * 装箱要求 [UDC]COM:PACK_DEMAND
     */
    @ApiModelProperty("装箱要求 [UDC]COM:PACK_DEMAND")
    private String packDemand;
    /**
     * 包装数量
     */
    @ApiModelProperty("包装数量")
    private BigDecimal packQty;
    /**
     * 包装单位
     */
    @ApiModelProperty("包装单位")
    private String packUom;
    /**
     * 单个净重
     */
    @ApiModelProperty("单个净重")
    private BigDecimal singleNetWeight;
    /**
     * 净重
     */
    @ApiModelProperty("净重")
    private BigDecimal netWeight;
    /**
     * 毛重
     */
    @ApiModelProperty("毛重")
    private BigDecimal grossWeight;
    /**
     * 重量单位
     */
    @ApiModelProperty("重量单位")
    private String weightUom;
    /**
     * 重量转换率 重量单位与主单位
     */
    @ApiModelProperty("重量转换率 重量单位与主单位")
    private BigDecimal weightRatio;
    /**
     * 单个体积
     */
    @ApiModelProperty("单个体积")
    private BigDecimal singleVolume;
    /**
     * 体积
     */
    @ApiModelProperty("体积")
    private BigDecimal volume;
    /**
     * 体积单位
     */
    @ApiModelProperty("体积单位")
    private String volumeUom;
    /**
     * 基价
     */
    @ApiModelProperty("基价")
    private BigDecimal basePrice;
    /**
     * 价格类型
     */
    @ApiModelProperty("价格类型")
    private String priceType;
    /**
     * 含税价格
     */
    @ApiModelProperty("含税价格")
    private BigDecimal price;
    /**
     * 不含税价格
     */
    @ApiModelProperty("不含税价格")
    private BigDecimal netPrice;
    /**
     * 客户含税价格
     */
    @ApiModelProperty("客户含税价格")
    private BigDecimal refTaxPrice;
    /**
     * 折扣率
     */
    @ApiModelProperty("折扣率")
    private BigDecimal discRatio;
    /**
     * 折扣未税额
     */
    @ApiModelProperty("折扣未税额")
    private BigDecimal discNetAmt;
    /**
     * 折扣含税额
     */
    @ApiModelProperty("折扣含税额")
    private BigDecimal discAmt;
    /**
     * 折扣描述
     */
    @ApiModelProperty("折扣描述")
    private String discDesc;
    /**
     * 客户未税价格
     */
    @ApiModelProperty("客户未税价格")
    private BigDecimal refPrice;
    /**
     * 交易未税单价 折扣后
     */
    @ApiModelProperty("交易未税单价 折扣后")
    private BigDecimal transNetPrice;
    /**
     * 交易含税单价 折扣后
     */
    @ApiModelProperty("交易含税单价 折扣后")
    private BigDecimal transPrice;
    /**
     * 应支付金额
     */
    @ApiModelProperty("应支付金额")
    private BigDecimal apAmt;
    /**
     * 已支付金额
     */
    @ApiModelProperty("已支付金额")
    private BigDecimal payedAmt;
    /**
     * 未结金额
     */
    @ApiModelProperty("未结金额")
    private BigDecimal openAmt;
    /**
     * 支付状态
     */
    @ApiModelProperty("支付状态")
    private String payStatus;
    private String payStatusName;
    /**
     * 发票状态
     */
    @ApiModelProperty("发票状态")
    private String invStatus;
    private String invStatusName;
    /**
     * 发票日期
     */
    @ApiModelProperty("发票日期")
    private LocalDateTime invDate;
    /**
     * 客户税类型
     */
    @ApiModelProperty("客户税类型")
    private String custTaxType;
    /**
     * 商品税类型
     */
    @ApiModelProperty("商品税类型")
    private String itemTaxType;
    /**
     * 税码
     */
    @ApiModelProperty("税码")
    private String taxCode;
    /**
     * 税率编号
     */
    @ApiModelProperty("税率编号")
    private String taxRateNo;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额")
    private BigDecimal amt;
    /**
     * 未税原金额
     */
    @ApiModelProperty("未税原金额")
    private BigDecimal orignNetAmt;
    /**
     * 含税原金额
     */
    @ApiModelProperty("含税原金额")
    private BigDecimal orignAmt;
    /**
     * 不含税金额
     */
    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;
    /**
     * 外币含税金额
     */
    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;
    /**
     * 外币不含税金额
     */
    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;
    /**
     * 本币币种
     */
    @ApiModelProperty("本币币种")
    private String homeCurr;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    /**
     * 汇率
     */
    @ApiModelProperty("汇率")
    private BigDecimal currRate;
    /**
     * 允收期编码
     */
    @ApiModelProperty("允收期编码")
    private String aapCode;

    /**
     * 配货数量
     */
    @ApiModelProperty("配货数量")
    private BigDecimal allocQty;
    /**
     * 配货状态 [UDC]SAL:SO_ALLOC_STATUS
     */
    @ApiModelProperty("配货状态 [UDC]SAL:SO_ALLOC_STATUS")
    private String allocStatus;
    private String allocStatusName;
    /**
     * 物流状态 [UDC]SAL:SO_LOGIS_STATUS
     */
    @ApiModelProperty("物流状态 [UDC]SAL:SO_LOGIS_STATUS")
    private String logisStatus;

    @ApiModelProperty("签收状态")
    private String confirmStatus;
    /**
     * 要求日期
     */
    @ApiModelProperty("要求日期")
    private LocalDateTime demandDate;
    /**
     * 计划出库日期
     */
    @ApiModelProperty("计划出库日期")
    private LocalDateTime planShipDate;
    /**
     * 承诺交货日期
     */
    @ApiModelProperty("承诺交货日期")
    private LocalDateTime promiseDeliverDate;
    /**
     * 出库确认时间
     */
    @ApiModelProperty("出库确认时间")
    private LocalDateTime shipConfirmTime;
    /**
     * 发货未税金额
     */
    @ApiModelProperty("发货未税金额")
    private BigDecimal shippedNetAtm;
    /**
     * 暂挂原因码 [UDC]SAL:SO_HOLD_REASON
     */
    @ApiModelProperty("暂挂原因码 [UDC]SAL:SO_HOLD_REASON")
    private String holdReasonCode;
    private String holdReasonCodeName;
    /**
     * 暂挂数量
     */
    @ApiModelProperty("暂挂数量")
    private BigDecimal holdQty;
    /**
     * 暂挂时间
     */
    @ApiModelProperty("暂挂时间")
    private LocalDateTime holdTime;
    /**
     * 暂挂描述
     */
    @ApiModelProperty("暂挂描述")
    private String holdReasonDesc;
    /**
     * 暂挂用户ID
     */
    @ApiModelProperty("暂挂用户ID")
    private Long holdUserId;
    /**
     * 退货原因码 [UDC]SAL:SO_RETURN_REASON
     */
    @ApiModelProperty("退货原因码 [UDC]SAL:SO_RETURN_REASON")
    private String returnReasonCode;
    @ApiModelProperty("退货原因码 Name")
    private String returnReasonCodeName;
    /**
     * 已退货数量
     */
    @ApiModelProperty("已退货数量")
    private BigDecimal returnedQty;
    /**
     * 已取消数量
     */
    @ApiModelProperty("已取消数量")
    private BigDecimal cancelQty;
    /**
     * 已取消含税金额
     */
    @ApiModelProperty("已取消含税金额")
    private BigDecimal cancelAtm;
    /**
     * 取消时间
     */
    @ApiModelProperty("取消时间")
    private LocalDateTime cancelTime;
    /**
     * 取消原因 [UDC]SAL:SO_CANCEL_REASON
     */
    @ApiModelProperty("取消原因 [UDC]SAL:SO_CANCEL_REASON")
    private String cancelReason;
    /**
     * 取消用户ID
     */
    @ApiModelProperty("取消用户ID")
    private Long cancelUserId;
    /**
     * 已退货含税金额
     */
    @ApiModelProperty("已退货含税金额")
    private BigDecimal returnedAtm;
    /**
     * 已退货未税金额
     */
    @ApiModelProperty("已退货未税金额")
    private BigDecimal returnedNetAtm;
    /**
     * 已出库数量
     */
    @ApiModelProperty("已出库数量")
    private BigDecimal shippedQty;
    @ApiModelProperty("未发货数量")
    private BigDecimal unShippedQty;

    /**
     * 已签收数量
     */
    @ApiModelProperty("已签收数量")
    private BigDecimal confirmQty;
    /**
     * 硬承诺数量
     */
    @ApiModelProperty("硬承诺数量")
    private BigDecimal hardPromiseQty;
    /**
     * 已取消未税金额
     */
    @ApiModelProperty("已取消未税金额")
    private BigDecimal cancelNetAtm;
    /**
     * 拣货数量
     */
    @ApiModelProperty("拣货数量")
    private BigDecimal pickedQty;

    private String  whCode;
    private String  whType;
    private String whName;
    /**
     * 发货含税金额
     */
    @ApiModelProperty("发货含税金额")
    private BigDecimal shippedAtm;
    /**
     * 根ID
     */
    @ApiModelProperty("根ID")
    private Long rootId;
    /**
     * 关联单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    private String relateDocCls;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据明细ID
     */
    @ApiModelProperty("关联单据明细ID")
    private Long relateDocDid;
    /**
     * 关联单据行号
     */
    @ApiModelProperty("关联单据行号")
    private BigDecimal relateDocLineno;
    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    private String relateDoc2Cls;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID
     */
    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;
    /**
     * 关联单据2编号
     */
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    /**
     * 关联单据2明细ID
     */
    @ApiModelProperty("关联单据2明细ID")
    private Long relateDoc2Did;
    /**
     * 关联单据2行号
     */
    @ApiModelProperty("关联单据2行号")
    private BigDecimal relateDoc2Lineno;
    /**
     * 外部单据公司
     */
    @ApiModelProperty("外部单据公司")
    private String outerOu;
    /**
     * 外部单据类型
     */
    @ApiModelProperty("外部单据类型")
    private String outerType;
    /**
     * 外部单据编号
     */
    @ApiModelProperty("外部单据编号")
    private String outerNo;
    /**
     * 外部单据行号
     */
    @ApiModelProperty("外部单据行号")
    private String outerLineno;

    /**
     * 租户ID
     */
    @ApiModelProperty("租户ID")
    private Long tenantId;
    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;
    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;
    /**
     * 记录创建者
     */
    @ApiModelProperty("记录创建者")
    private String creator;
    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId;
    /**
     * 记录最后更新者
     */
    @ApiModelProperty("记录最后更新者")
    private String updater;
    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
     * 逻辑删除，0：未删除，1：已删除
     */
    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;
    /**
     * 锁版本
     */
    @ApiModelProperty("锁版本")
    private Integer auditDataVersion;

    /**
     * 排期类型(订单明细中参数，订单更新数据业务需求)
     */
    @ApiModelProperty("排期类型")
    private String scheduleType;
    private String scheduleTypeName;
    @ApiModelProperty("来源单据明细ID ")
    private Long rootDocDId;

    @ApiModelProperty("来源单据行号 ")
    private Long rootDocLineno;

    /**
     * 关联单据类别 来源采购订单等。[UDC]COM:DOC_CLS
     */
    @ApiModelProperty("来源单据类别 ")
    private String rootDocCls;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String rootDocType;
    /**
     * 关联单据ID
     */
    @ApiModelProperty("关联单据ID")
    private Long rootDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String rootDocNo;
    /**
     * 仓库合作伙伴编号,如果是网格个人仓，传网格员员工编号
     */
    @ApiModelProperty("仓库合作伙伴编号,如果是网格个人仓，传网格员员工编号")
    private String whPCode;

    /**
     * 网格个人仓名称
     */
    private String whPName;
    /**
     * 仓库合作伙伴类型，如果是网格个人仓，传EMP
     */
    @ApiModelProperty("仓库合作伙伴类型，如果是网格个人仓，传EMP")
    private String whPType;

    /**
     * 退款状态
     */
    @ApiModelProperty("退款状态")
    private String refundStatus;
    private String refundStatusName;

    /**
     * 批准退款金额
     */
    @ApiModelProperty("批准退款金额")
    private BigDecimal refundAmt;
    /**
     * 实际退货金额
     */
    @ApiModelProperty("实际退货金额")
    private BigDecimal confirmAmt;


    /**
     * 订单发货数量
     */
    @ApiModelProperty("订单发货数量")
    private BigDecimal shipQty;

    /**
     * 可退数量
     */
    @ApiModelProperty("可退数量")
    private BigDecimal allowReturnQty;
    /**
     * 取消中数量
     */
    @ApiModelProperty("取消中数量")
    private BigDecimal cancellingQty;

    @ApiModelProperty("已拒收数量")
    private BigDecimal rejectQty;

    @ApiModelProperty("出货方式")
    private String sellMethod;

    @ApiModelProperty("采购状态 0-无采购；1-采购审批中；2-已采购；3-已发货")
    private String purStatus;

    @ApiModelProperty("采购类型po_type 0—自采采购 1—代发采购")
    private Integer poType;

    @ApiModelProperty("采购订单ID")
    private Long poId;
}
