package com.elitesland.order.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author Shadow
 * @since 2021-07-12 15:20
 */
@Data
@ApiModel(value = "SalSoDQueryDTO", description = "退款单查询")
public class SalSoDQueryDTO implements Serializable {

    private static final long serialVersionUID = -6532067629175562586L;

    @ApiModelProperty("订单明细ID列表")
    private List<Long> sodIds;

    @ApiModelProperty("客户编码")//so
    private String custCode;
    @ApiModelProperty("客户ID")//so
    private Long custId;

    @ApiModelProperty("退货订单号")
    private String docNo;//so

    @ApiModelProperty("退货订单日期")
    private LocalDateTime docTimeStart;//so

    @ApiModelProperty("订单日期")
    private LocalDateTime docTimeEnd;//so

    @ApiModelProperty("退款单状态")//so
    private String docStatus;

    @ApiModelProperty("退货订单类型")
    private String docType;

    @ApiModelProperty("分页页码 默认：0")
    private Integer current;

    @ApiModelProperty("分页大小 默认：10")
    private Integer size;

}
