package com.elitesland.order.param;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import com.elitescloud.boot.common.param.BaseViewModel;

@ApiModel(value = "ToBRSalSoSaveDTO", description = "退货订单表")
@Data
public class ToBRSalSoSaveDTO extends BaseViewModel implements Serializable {

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    private Boolean autoCheckFlag;
    private String ouCode;
    private String ouName;
    private String buCode;
    private String confirmStatus;
    //网格员编码
    private String buCode2;
    private String buName;

    @ApiModelProperty("优惠券金额")
    private BigDecimal couponAmt;

    @ApiModelProperty("购物卡金额")
    private BigDecimal cardAmt;
    @ApiModelProperty("提货券金额")
    private BigDecimal giftAmt;
    @ApiModelProperty("使用积分金额")
    private BigDecimal usePointAmt;

    @ApiModelProperty("发放积分金额")
    private BigDecimal getPointAmt;

    /**
     * 订单价格
     */
    private List<SalSoPriceSaveDTO> salSoPriceSaveDTOS;
    /**
     * 订单收款
     */
    private List<SalSoReceiptSaveDTO> salSoReceiptSaveDTOS;
    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    /**
     * BUID2
     */
    @ApiModelProperty("BUID2")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId2;

    /**
     * 单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("单据类别 [UDC]COM:DOC_CLS")
    private String docCls;
    /**
     * 单据编号
     */
    @ApiModelProperty("中台的订单流水号")
    private String docNo;
    /**
     * 单据编号2
     */
    @ApiModelProperty("单据编号2")
    private String docNo2;

    /**
     * 单据类型 [UDC]SAL:SO_TYPE
     */
    @ApiModelProperty("单据类型 [UDC]SAL:SO_TYPE")
    private String docType;
    /**
     * 单据类型2
     */
    @ApiModelProperty("单据类型2")
    private String docType2;
    /**
     * 单据类型3
     */
    @ApiModelProperty("单据类型3")
    private String docType3;
    /**
     * 单据状态 [UDC]SAL:SO_STATUS/RSO_STATUS
     */
    @ApiModelProperty("单据状态 [UDC]SAL:SO_STATUS/RSO_STATUS")
    private String docStatus;
    /**
     * 单据状态2
     */
    @ApiModelProperty("单据状态2")
    private String docStatus2;
    /**
     * 审批状态 [UDC]COM:APPR_STATUS
     */
    @ApiModelProperty("审批状态 [UDC]COM:APPR_STATUS")
    private ProcInstStatus apprStatus;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime apprTime;
    /**
     * 审批人ID
     */
    @ApiModelProperty("审批人ID")
    private Long apprUserId;
    /**
     * 审批意见
     */
    @ApiModelProperty("审批意见")
    private String apprComment;
    /**
     * 下单时间
     */
    @ApiModelProperty("订单日期")
    private LocalDateTime docTime;
    /**
     * 销售场景
     */
    @ApiModelProperty("销售场景")
    private String soScene;
    /**
     * 客户订单号码
     */
    @ApiModelProperty("客户订单号码")
    private String custSoNo;
    /**
     * 客户订单日期
     */
    @ApiModelProperty("客户订单日期")
    private LocalDateTime custSoDate;
    /**
     * 客户联系人 客户跟单人员
     */
    @ApiModelProperty("收货联系人（姓名）")
    private String custContactName;
    /**
     * 客户联系人电话
     */
    @ApiModelProperty("收货联系人电话")
    private String custContactTel;
    /**
     * 客户联系人邮箱
     */
    @ApiModelProperty("客户联系人邮箱")
    private String custContactEmail;
    /**
     * 暂挂原因码 [UDC]SAL:SO_HOLD_REASON
     */
    @ApiModelProperty("暂挂原因码 [UDC]SAL:SO_HOLD_REASON")
    private String holdReasonCode;
    /**
     * 暂挂时间
     */
    @ApiModelProperty("暂挂时间")
    private LocalDateTime holdTime;
    /**
     * 暂挂描述
     */
    @ApiModelProperty("暂挂描述")
    private String holdReasonDesc;
    /**
     * 失效日期
     */
    @ApiModelProperty("失效日期")
    private LocalDateTime invalidDate;
    /**
     * 越库标识
     */
    @ApiModelProperty("越库标识")
    private String crosswhFlag;

    /**
     * 下单渠道
     */
    @ApiModelProperty("下单渠道不能为空")
    private String soSource;
    /**
     * 销售区域 [UDC]SAL:SAL_REGION
     */
    @ApiModelProperty("销售区域 [UDC]SAL:SAL_REGION")
    private String saleRegion;
    /**
     * 配送区域
     */
    @ApiModelProperty("配送区域")
    private String deliverRegion;
    /**
     * 客户ID 售至
     */
    @ApiModelProperty("客户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty("客户编号")
    private String custCode;
    /**
     * 客户名称
     */
    @ApiModelProperty("会员姓名(昵称)")
    private String custName;

    /**
     * 客户渠道
     */
    @ApiModelProperty("客户渠道")
    private String custChannel;
    /**
     * 开票至客户ID
     */
    @ApiModelProperty("开票至客户ID")
    private Long billtoCustId;
    /**
     * 销售组
     */
    @ApiModelProperty("销售组")
    private String saleGroup;
    /**
     * 业务员员工ID
     */
    @ApiModelProperty("业务员员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long agentEmpId;
    private String empName;

    private String empCode;
    /**
     * 本币币种
     */
    @ApiModelProperty("本币币种")
    private String homeCurr;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    /**
     * 汇率
     */
    @ApiModelProperty("汇率")
    private BigDecimal currRate;
    /**
     * 是否含税
     */
    @ApiModelProperty("是否含税")
    private String taxInclFlag;
    /**
     * 税码
     */
    @ApiModelProperty("税码")
    private String taxCode;
    /**
     * 税率编号
     */
    @ApiModelProperty("税率编号")
    private String taxRateNo;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    private BigDecimal orignAmt;
    /**
     * 含税总金额
     */
    @ApiModelProperty("含税总金额")
    private BigDecimal amt;
    /**
     * 未税总金额
     */
    @ApiModelProperty("未税总金额")
    private BigDecimal netAmt;
    /**
     * 未税原金额
     */
    @ApiModelProperty("未税原金额")
    private BigDecimal orignNetAmt;
    /**
     * 含税原金额
     */
    @ApiModelProperty("含税原金额")
    private BigDecimal oringAmt;
    /**
     * 未税运费金额
     */
    @ApiModelProperty("未税运费金额")
    private BigDecimal freightFee;
    /**
     * 外币不含税金额
     */
    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;
    /**
     * 外币含税金额
     */
    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;

    @ApiModelProperty("应支付金额")
    private BigDecimal apAmt;

    @ApiModelProperty("已支付金额")
    private BigDecimal payedAmt;
    @ApiModelProperty("未结金额")
    private BigDecimal openAmt;
    /**
     * 总数量
     */
    @ApiModelProperty("总数量")
    private BigDecimal qty;
    /**
     * 数量单位
     */
    @ApiModelProperty("数量单位")
    private String qtyUom;
    /**
     * 总数量2
     */
    @ApiModelProperty("总数量2")
    private BigDecimal qty2;
    /**
     * 数量2单位
     */
    @ApiModelProperty("数量2单位")
    private String qty2Uom;
    /**
     * 净重
     */
    @ApiModelProperty("净重")
    private BigDecimal netWeight;
    /**
     * 毛重
     */
    @ApiModelProperty("毛重")
    private BigDecimal grossWeight;
    /**
     * 重量单位
     */
    @ApiModelProperty("重量单位")
    private String weightUom;
    /**
     * 体积
     */
    @ApiModelProperty("体积")
    private BigDecimal volume;
    /**
     * 体积单位
     */
    @ApiModelProperty("体积单位")
    private String volumeUom;
    /**
     * 付款条款
     */
    @ApiModelProperty("付款条款")
    private String paymentTerm;

    /**
     * 装箱要求 [UDC]COM:PACK_DEMAND
     */
    @ApiModelProperty("装箱要求 [UDC]COM:PACK_DEMAND")
    private String packDemand;
    /**
     * 支付状态
     */
    @ApiModelProperty("支付状态")
    private String payStatus;
    /**
     * 支付时间
     */
    @ApiModelProperty("支付时间")
    private LocalDateTime payTime;
    /**
     * 支付交易ID
     */
    @ApiModelProperty("支付交易ID")
    private Long payTransId;
    /**
     * 付款方式 [UDC]COM:PAY_METHOD
     */
    @ApiModelProperty("付款方式 [UDC]COM:PAY_METHOD")
    private String payMethod;
    /**
     * 物流状态
     */
    @ApiModelProperty("物流状态")
    private String logisStatus;
    /**
     * 运输方式 [UDC]COM:TP_TYPE
     */
    @ApiModelProperty("运输方式 [UDC]COM:TP_TYPE")
    private String transType;
    /**
     * 承运商
     */
    @ApiModelProperty("承运商")
    private String carrier;
    /**
     * 从地点
     */
    @ApiModelProperty("从地点")
    private String fromLoc;
    /**
     * 到地点
     */
    @ApiModelProperty("到地点")
    private String toLoc;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    private String whCode;
    private String whName;
    /**
     * 限定1
     */
    @ApiModelProperty("限定1")
    private String deter1;
    /**
     * 限定2
     */
    @ApiModelProperty("限定2")
    private String deter2;

    /**
     * 库位
     */
    @ApiModelProperty("库位")
    private String whLoc;
    /**
     * 货位
     */
    @ApiModelProperty("货位")
    private String whPosi;
    /**
     * 要求日期
     */
    @ApiModelProperty("要求日期")
    private LocalDateTime demandDate;
    /**
     * 计划出库日期
     */
    @ApiModelProperty("计划出库日期")
    private LocalDateTime planShipDate;
    /**
     * 承诺交货日期
     */
    @ApiModelProperty("承诺交货日期")
    private LocalDateTime promiseDeliverDate;
    /**
     * 出库确认时间
     */
    @ApiModelProperty("出库确认时间")
    private LocalDateTime shipConfirmTime;
    /**
     * 确认收货时间
     */
    @ApiModelProperty("确认收货时间")
    private LocalDateTime recvConfirmTime;
    /**
     * 发货指令
     */
    @ApiModelProperty("交货指令1")
    private String deliverInstruct;
    /**
     * 发货指令2
     */
    @ApiModelProperty("交货指令2")
    private String deliverInstruc2;
    /**
     * 配送方式 [UDC]SAL:SO_DELIVER_METHOD
     */
    @ApiModelProperty("配送方式 [UDC]SAL:SO_DELIVER_METHOD")
    private String deliverMethod;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    private Long recvWhId;
    /**
     * 收方限定1
     */
    @ApiModelProperty("收方限定1")
    private String recvDeter1;
    /**
     * 收方限定2
     */
    @ApiModelProperty("收方限定2")
    private String recvDeter2;

    /**
     * 收货地址号
     */
    @ApiModelProperty("收货地址号")
    private Long recvAddrNo;
    /**
     * 收货联系人
     */
    @ApiModelProperty("收货联系人")
    private String recvContactName;
    /**
     * 收货联系电话
     */
    @ApiModelProperty("收货联系电话")
    private String recvContactTel;
    /**
     * 收货联系人邮箱
     */
    @ApiModelProperty("收货联系人邮箱")
    private String recvContactEmail;
    /**
     * 收货国家
     */
    @ApiModelProperty("收货国家")
    private String recvCountry;
    /**
     * 收货省
     */
    @ApiModelProperty("收货省")
    private String recvProvince;
    /**
     * 收货市
     */
    @ApiModelProperty("收货市")
    private String recvCity;
    /**
     * 收货区县
     */
    @ApiModelProperty("收货区县")
    private String recvCounty;
    /**
     * 收货乡镇街道
     */
    @ApiModelProperty("收货乡镇街道")
    private String recvStreet;
    /**
     * 收货详细地址
     */
    @ApiModelProperty("收货详细地址")
    private String recvDetailaddr;
    /**
     * 退货原因码 [UDC]SAL:SO_RETURN_REASON
     */
    @ApiModelProperty("退货原因码 [UDC]SAL:SO_RETURN_REASON")
    private String returnReasonCode;
    /**
     * 退货状态
     */
    @ApiModelProperty("退货状态")
    private String returnStatus;
    /**
     * 退货申请时间
     */
    @ApiModelProperty("退货申请时间")
    private LocalDateTime returnApplyTime;
    /**
     * 退货批准时间
     */
    @ApiModelProperty("退货批准时间")
    private LocalDateTime returnApprTime;
    /**
     * 未税折扣金额
     */
    @ApiModelProperty("未税折扣金额")
    private BigDecimal discNetAmt;
    /**
     * 关单原因码 [UDC]SAL:SO_CLOSE_REASON
     */
    @ApiModelProperty("关单原因码 [UDC]SAL:SO_CLOSE_REASON")
    private String closeReasonCode;
    /**
     * 关单人ID
     */
    @ApiModelProperty("关单人ID")
    private Long closeUserId;
    /**
     * 含税发运总金额
     */
    @ApiModelProperty("含税发运总金额")
    private BigDecimal shippedAmt;
    /**
     * 未税发运总金额
     */
    @ApiModelProperty("未税发运总金额")
    private BigDecimal shippedNetAmt;

    @ApiModelProperty("合同编号")
    private String contractCode;
    @ApiModelProperty("合同id")
    private String contractId;
    @ApiModelProperty("合同名称")
    private String contractName;
    /**
     * 含税退货总金额
     */
    @ApiModelProperty("含税退货总金额")
    private BigDecimal returnAmt;
    /**
     * 未税退货总金额
     */
    @ApiModelProperty("未税退货总金额")
    private BigDecimal returnNetAmt;
    /**
     * 取消时间
     */
    @ApiModelProperty("取消时间")
    private LocalDateTime cancelTime;
    /**
     * 取消原因 [UDC]SAL:SO_CANCEL_REASON
     */
    @ApiModelProperty("取消原因 [UDC]SAL:SO_CANCEL_REASON")
    private String cancelReason;
    /**
     * 取消用户ID
     */
    @ApiModelProperty("取消用户ID")
    private Long cancelUserId;
    /**
     * 退款状态
     */
    @ApiModelProperty("退款状态")
    private String refundStatus;
    /**
     * 退款时间
     */
    @ApiModelProperty("退款时间")
    private LocalDateTime refundTime;
    /**
     * 退款金额
     */
    @ApiModelProperty("退款金额")
    private BigDecimal refundAmt;
    /**
     * 折扣率
     */
    @ApiModelProperty("折扣率")
    private BigDecimal discRatio;
    /**
     * 含税折扣金额
     */
    @ApiModelProperty("含税折扣金额")
    private BigDecimal discAmt;
    /**
     * 折扣描述
     */
    @ApiModelProperty("折扣描述")
    private String discDesc;
    /**
     * 发票状态
     */
    @ApiModelProperty("发票状态")
    private String invStatus;
    /**
     * 发票日期
     */
    @ApiModelProperty("发票日期")
    private String invDate;
    /**
     * 供应商ID 用于代发
     */
    @ApiModelProperty("供应商ID 用于代发")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    /**
     * 根ID
     */
    @ApiModelProperty("根ID")
    private Long rootId;
    /**
     * 关联单据类别 来源采购订单等。[UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 来源采购订单等。[UDC]COM:DOC_CLS")
    private String relateDocCls;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    private String relateDoc2Cls;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID
     */
    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;
    /**
     * 关联单据2编号
     */
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    /**
     * 关联ID
     */
    @ApiModelProperty("关联ID")
    private Long relateId;
    /**
     * 未税原总金额
     */
    @ApiModelProperty("未税原总金额")
    private BigDecimal oringNetAmt;
    /**
     * 关联编号
     */
    @ApiModelProperty("source_so_id:第二层原订单号。表示没有按仓库拆分之前的订单号。")
    private String relateNo;
    /**
     * 关联2ID
     */
    @ApiModelProperty("关联2ID")
    private Long relate2Id;
    /**
     * 关联2编号
     */
    @ApiModelProperty("关联2编号")
    private String relate2No;
    /**
     * 外部单据公司
     */
    @ApiModelProperty("外部单据公司")
    private String outerOu;
    /**
     * 外部单据类型
     */
    @ApiModelProperty("外部单据类型")
    private String outerType;
    /**
     * 外部单据编号
     */
    @ApiModelProperty("so_num_id：第三层发货任务单,与中台订单一对一。")
    private String outerNo;
    /**
     * 备注2
     */
    @ApiModelProperty("备注2")
    private String remark2;
    /**
     * 确认时间
     */
    @ApiModelProperty("确认时间")
    private LocalDateTime confirmedTime;
    /**
     * 是否走接口
     */
    @ApiModelProperty("是否走接口")
    private String intfFlag;
    /**
     * 附件code 数组
     */
    @ApiModelProperty("附件code 数组")
    private List<String> fileCodes;

    /**
     * 订单明细
     */
    @ApiModelProperty("订单明细")
    private List<ToBSalSoDSaveDTO> salSoDSaveDTOList;

    @ApiModelProperty("制单人电话")
    private String creatorTel;

    @ApiModelProperty("退货类型")
    private String returnType;

    /**
     * 配货状态 [UDC]SAL:SO_ALLOC_STATUS
     */
    @ApiModelProperty("配货状态 [UDC]SAL:SO_ALLOC_STATUS")
    private String allocStatus;

    /**
     * 订单开票
     */
    private List<SalSoInvSaveDTO> salSoInvSaveDTOS;

}

