package com.elitesland.order.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.order.param
 * @date 2023/8/30 11:45
 */

@Data
@ApiModel(value = "SalSoDInvDTO", description = "销售订单明细表开票信息")
public class SalSoDInvDTO implements Serializable {


    @ApiModelProperty("主键id")
    private Long id;


    @ApiModelProperty("已开票金额")
    private BigDecimal invedAmt;


    @ApiModelProperty("开票中金额")
    private BigDecimal invingAmt;


    @ApiModelProperty("待开票金额")
    private BigDecimal noinvAmt;


    @ApiModelProperty("已开票数量")
    private BigDecimal invedQty;


    @ApiModelProperty("开票中数量")
    private BigDecimal invingQty;


    @ApiModelProperty("待开票数量")
    private BigDecimal noinvQty;


}
