package com.elitesland.order.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
@ApiModel(value = "SalDoReturnQueryDTO", description = "协同数据查询")
public class SalDoReturnQueryDTO extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = -3655730194655339418L;

    //查询条件：平台订单单据编号,退货收货单编号,商品名称,店铺,平台订单创建日期,退货收货单创建日期,商品编号,客户名称,商品品牌,客户手机,页码，页大小

    /**
     * 退货收货单编号
     */
    @ApiModelProperty("退货收货单编号")
    private String docNo;

    /**
     * 退货单据编号
     */
    @ApiModelProperty("退货单据编号")
    private String relateDocNo;

    /**
     * 平台订单单据编号
     */
    @ApiModelProperty("平台订单单据编号")
    private String relateDoc2No;

    /**
     * 店铺id
     */
    @ApiModelProperty("店铺id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    /**
     * 店铺名称
     */
    @ApiModelProperty("店铺名称")
    private String buName;

    /**
     * 平台订单创建日期开始
     */
    @ApiModelProperty("平台订单创建日期开始")
    private String createTimeOrderStart;

    /**
     * 平台订单创建日期结束
     */
    @ApiModelProperty("平台订单创建日期结束")
    private String createTimeOrderEnd;

    /**
     * 退货收货单创建日期开始
     */
    @ApiModelProperty("退货收货单创建日期开始")
    private String createTimeStart;

    /**
     * 退货收货单创建日期结束
     */
    @ApiModelProperty("退货收货单创建日期结束")
    private String createTimeEnd;

    /**
     * 商品名称
     */
    @ApiModelProperty("商品名称")
    private String itemName;

    /**
     * 商品编号
     */
    @ApiModelProperty("商品编号")
    private String itemCode;

    /**
     * 商品品牌
     */
    @ApiModelProperty("商品品牌")
    private String itemBrand;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String recvContactName;

    /**
     * 客户手机
     */
    @ApiModelProperty("客户手机")
    private String recvContactTel;

    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    @NotNull(message = "供应商ID不能为空")
    private Long suppId;
}
