package com.elitesland.order.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class SalSoDateDTO implements Serializable {

    private static final long serialVersionUID = 751043965083426103L;

    @ApiModelProperty("销售单id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 店铺名称
     */
    @ApiModelProperty("店铺名称")
    private String storeName;

    @ApiModelProperty("排期类型")
    private String scheduleType;
    /**
     * 平台订单号
     */
    @ApiModelProperty("平台订单号")
    private String docNo2;

    /**
     * 订单创建日期
     */
    @ApiModelProperty("订单创建日期")
    private LocalDateTime createTime;

    /**
     * 收货人
     */
    @ApiModelProperty("收货人")
    private String custContactName;

    /**
     * 收货人电话
     */
    @ApiModelProperty("收货人电话")
    private String custContactTel;

    /**
     * 收货国家
     */
    @ApiModelProperty("收货国家")
    private String recvCountry;
    /**
     * 收货省份
     */
    @ApiModelProperty("收货省份")
    private String recvProvince;
    /**
     * 收货省份Name
     */
    @ApiModelProperty("收货省份Name")
    private String recvProvinceName;
    /**
     * 城市
     */
    @ApiModelProperty("城市(编号/ID)")
    private String recvCity;
    @ApiModelProperty("城市名称")
    private String recvCityName;
    /**
     * 区县
     */
    @ApiModelProperty("区县(编号/ID)")
    private String recvCounty;
    @ApiModelProperty("区县名称")
    private String recvCountyName;

    /**
     * 收货地址拼接
     */
    @ApiModelProperty("收货地址拼接")
    private String recvAddress;

    /**
     * 收货详细地址
     */
    @ApiModelProperty("收货详细地址")
    private String recvDetailaddr;

    /**
     * 发货状态
     */
    @ApiModelProperty("发货状态:UDC[SAL:SO_LOGIS_STATUS]")
    private String logisStatus;
    /**
     * 订单状态
     */
    @ApiModelProperty("订单状态")
    private String docStatus;

    /**
     * 指定送货日期
     */
    @ApiModelProperty("指定送货日期")
    private LocalDateTime specifySendDate;

    /**
     * 指定送货时间
     */
    @ApiModelProperty("指定送货时间")
    private LocalDateTime specifySendTime;

    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @NotEmpty(message = "供应商ID不能为空")
    private Long suppId;
    /**
     * 销售订单号
     */
    @ApiModelProperty("销售订单号")
    private String docNo;


    @ApiModelProperty("商品名称")
    private String itemName;


    /**
     * 商品id
     */
    @ApiModelProperty("商品id")
    private Long itemId;
    /**
     * 商品编号
     */
    @ApiModelProperty("商品编号")
    private String itemCode;

    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String itemBrand;


    @ApiModelProperty("单据类型 [UDC]SAL:SO_TYPE'")
    private String docType;
    @ApiModelProperty("订单日期")
    private LocalDateTime docTime;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("供应商编号")
    private String suppCode;

    @ApiModelProperty("指定送货时间")
    private LocalDateTime demandTimespan;
    /**
     * 要求日期
     */
    @ApiModelProperty("要求日期")
    private LocalDateTime demandDate;

    @ApiModelProperty("销售单明细id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long soDId;

    @ApiModelProperty("已取消数量")
    private BigDecimal cancelQty;

    @ApiModelProperty("取消中数量")
    private BigDecimal cancellingQty;

    @ApiModelProperty("已退货数量")
    private BigDecimal returnedQty;
    @ApiModelProperty("行号")
    private BigDecimal lineNo;

    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String uom;
    /**
     * 订单数量-数量与单位合并显示，格式是10台
     */
    @ApiModelProperty("订单数量")
    private BigDecimal qty;
    /**
     * 已发货数量
     */
    @ApiModelProperty("已发货数量")
    private BigDecimal shippedQty;

    /**
     * 待发货数量
     */
    @ApiModelProperty("待发货数量")
    private BigDecimal waitQty;

    /**
     * 物流数据集合
     */
    @ApiModelProperty("物流数据集合")
    private List<SalLogislogDTO> salLogislogDTOList;

    /**
     * 拣货状态
     */
    @ApiModelProperty("拣货状态 [UDC]SAL:SO_PICKING_STATUS")
    private String pickingStatus;

    /**
     * 售后状态
     */
    @ApiModelProperty("售后状态 [UDC]SAL:SO_RETURN_STATUS")
    private String returnStatus;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;
    @Data
    @ApiModel(description = "物流数据")
    public static class SalLogislogDTO implements Serializable{
        private static final long serialVersionUID = -8482103237979266513L;
        /**
         * 物流公司ID
         */
        @ApiModelProperty("物流公司ID")
        private Long logisCarrierId;
        /**
         * 物流公司编号
         */
        @ApiModelProperty("物流公司编号")
        private String logisCarrierCode;
        /**
         * 物流公司名称
         */
        @ApiModelProperty("物流公司名称")
        private String logisCarrierName;
        /**
         * 物流单号
         */
        @ApiModelProperty("物流单号")
        private String logisDocNo;
    }
}
