package com.elitesland.order.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author brayson
 * @date 2025/10/29
 * @description
 */
@Data
@ApiModel("销售发票参数")
public class SalSaleInvRpcDTO implements Serializable {

    @ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty("来源单号ID")
    private Long sourceId;

    @ApiModelProperty("来源单号编码")
    private String sourceNo;

    @ApiModelProperty(value = "发票号码", required = true)
    private String invNo;

    @ApiModelProperty(value = "发票代码", required = true)
    private String invCode;

    @ApiModelProperty(value = "红蓝票,UDC[yst-fin:INV_RED_BLUE_TYPE]", required = true)
    //@SysCode(sys = "yst-fin", mod = "INV_RED_BLUE_TYPE")
    private String redBlueType;

    @ApiModelProperty(value = "发票类型,UDC [yst-fin:INV_TYPE]", required = true)
    //@SysCode(sys = "yst-fin", mod = "INV_TYPE")
    private String invType;

    @ApiModelProperty(value = "开票日期 yyyy-MM-dd HH:mm:ss", required = true)
    private LocalDateTime invDate;

    @ApiModelProperty(value = "含税金额", required = true)
    private BigDecimal amt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty(value = "未税金额", required = true)
    private BigDecimal untaxedAmt;

    @ApiModelProperty("发票校验码")
    private String invCheckCode;

    @ApiModelProperty("发票查验状态,UDC[yst-fin:INV_VERIFY_STATUS]")
    //@SysCode(sys = "yst-fin", mod = "INV_VERIFY_STATUS")
    private String invVerifyStatus;

    @ApiModelProperty(value = "附件名称", required = true)
    private String invFileName;

    /*@ApiModelProperty("附件内容")
    private byte[] fileContent;*/

    @ApiModelProperty(value = "附件编码", required = true)
    private String invFileCode;

    @ApiModelProperty("备注")
    private String remark;

}
