package com.elitesland.order.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class SalSoItemRespDTO implements Serializable {

    private static final long serialVersionUID = -8542730826203993116L;

    @ApiModelProperty("销售单id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    @ApiModelProperty("销售单明细id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long soDId;

    @ApiModelProperty("商品名称")
    private String itemName;
    /**
     * 商品编号
     */
    @ApiModelProperty("商品编号")
    private String itemCode;

    @ApiModelProperty("供应商id")
    private Long suppId;
    /**
     * 是否供应商代发
     */
    @ApiModelProperty("是否供应商代发")
    private String suppFlag;

    @ApiModelProperty("已取消数量")
    private BigDecimal cancelQty;

    @ApiModelProperty("取消中数量")
    private BigDecimal cancellingQty;

    @ApiModelProperty("已退货数量")
    private BigDecimal returnedQty;
    @ApiModelProperty("行号")
    private BigDecimal lineNo;
    /**
     * 要求日期
     */
    @ApiModelProperty("要求日期")
    private LocalDateTime demandDate;

    /**
     * 商品品牌
     */
    @ApiModelProperty("商品品牌")
    private String itemBrand;
    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String uom;
    /**
     * 订单数量-数量与单位合并显示，格式是10台
     */
    @ApiModelProperty("订单数量")
    private BigDecimal qty;
    /**
     * 已发货数量
     */
    @ApiModelProperty("已发货数量")
    private BigDecimal shippedQty;

    /**
     * 待发货数量
     */
    @ApiModelProperty("待发货数量")
    private BigDecimal waitQty;

    /**
     * 物流状态
     */
    @ApiModelProperty("物流状态")
    private String logisStatus;
    /**
     * 物流数据集合
     */
    @ApiModelProperty("物流数据集合")
    private List<SalLogislogDTO> salLogislogDTOList;
    /**
     * 拣货状态
     */
    @ApiModelProperty("拣货状态 [UDC]SAL:SO_PICKING_STATUS")
    private String pickingStatus;
    /**
     * 售后状态
     */
    @ApiModelProperty("售后状态 [UDC]SAL:SO_RETURN_STATUS")
    private String returnStatus;
    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;
    @Data
    @ApiModel(description = "物流数据")
    public static class SalLogislogDTO implements Serializable{
        private static final long serialVersionUID = -8482103237979266513L;
        /**
         * 物流公司ID
         */
        @ApiModelProperty("物流公司ID")
        private Long logisCarrierId;
        /**
         * 物流公司编号
         */
        @ApiModelProperty("物流公司编号")
        private String logisCarrierCode;
        /**
         * 物流公司名称
         */
        @ApiModelProperty("物流公司名称")
        private String logisCarrierName;
        /**
         * 物流单号
         */
        @ApiModelProperty("物流单号")
        private String logisDocNo;
    }
}
