package com.elitesland.order.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class SalSoDetailRespDTO implements Serializable {
    private static final long serialVersionUID = -6759740910978379663L;
    /**
     * 销售订单id
     */
    @ApiModelProperty("销售订单id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 销售订单明细id
     */
    @ApiModelProperty("销售订单明细id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long soDId;
    /**
     * 销售订单号
     */
    @ApiModelProperty("销售订单号")
    private String docNo;
    /**
     * 订单类型
     */
    @ApiModelProperty("订单类型")
    private String docType;
    /**
     * 行号
     */
    @ApiModelProperty("行号")
    private BigDecimal lineNo;
    /**
     * 行状态
     */
    @ApiModelProperty("行状态")
    private String lineStatus;
    @ApiModelProperty("单据状态")
    private String docStatus;
    /**
     * 商品名称
     */
    @ApiModelProperty("商品名称")
    private String itemName;
    /**
     * 商品id
     */
    @ApiModelProperty("商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;
    /**
     * 商品编号
     */
    @ApiModelProperty("商品编号")
    private String itemCode;
    /**
     * 公司名称
     */
    @ApiModelProperty("公司名称")
    private String ouName;
    /**
     * 公司id
     */
    @ApiModelProperty("公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    /**
     * 公司编号
     */
    @ApiModelProperty("公司编号")
    private String ouCode;
    /**
     * 商品规格
     */
    @ApiModelProperty("商品规格")
    private String itemSpec;
    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String itemBrand;
    /**
     * 数量
     */
    @ApiModelProperty("数量")
    private BigDecimal qty;
    /**
     * 数量
     */
    @ApiModelProperty("取消数量")
    private BigDecimal cancelQty;
    /**
     * 签收数量
     */
    @ApiModelProperty("签收数量")
    private BigDecimal confirmQty;
    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String uom;
    /**
     * 含税单价
     */
    @ApiModelProperty("含税单价")
    private BigDecimal price;
    /**
     * 未含税单价
     */
    @ApiModelProperty("未含税单价")
    private BigDecimal netPrice;
    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额")
    private BigDecimal amt;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 税率编号
     */
    @ApiModelProperty("税率编号")
    private String taxRateNo;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    /**
     * 应收款余额
     */
    @ApiModelProperty("应收款余额")
    private BigDecimal apAmt;

    /**
     * 已开票金额
     */
    @ApiModelProperty("已开票金额")
    private BigDecimal invedAmt;
    /**
     * 开票中金额
     */
    @ApiModelProperty("开票中金额")
    private BigDecimal invingAmt;
    /**
     * 收款中金额
     */
    @ApiModelProperty("收款中金额")
    private BigDecimal payingAmt;
    /**
     * 待开票金额
     */
    @ApiModelProperty("待开票金额")
    private BigDecimal noinvAmt;
    /**
     * 已开票数量
     */
    @ApiModelProperty("已开票数量")
    private BigDecimal invedQty;
    /**
     * 开票中数量
     */
    @ApiModelProperty("开票中数量")
    private BigDecimal invingQty;
    /**
     * 待开票数量
     */
    @ApiModelProperty("待开票数量")
    private BigDecimal noinvQty;

    /**
     * 已收款金额
     */
    @ApiModelProperty("已收款金额")
    private BigDecimal payedAmt;

    /**
     * 待付款金额
     */
    @ApiModelProperty("待付款金额")
    private BigDecimal openAmt;

    /**
     * 下单渠道
     */
    @ApiModelProperty("下单渠道")
    private String soSource;

    /**
     * 单据类型
     */
    @ApiModelProperty("单据类型")
    private String docCls;

    /**
     * 签收含税金额
     */
    @ApiModelProperty("签收含税金额")
    private BigDecimal confirmAmt;

    @ApiModelProperty("合同id")
    private Long contractId;
    @ApiModelProperty("合同code")
    private String contractCode;
    @ApiModelProperty("合同名称")
    private String contractName;

    @ApiModelProperty("关联单主表Id")
    private Long relateDocId;
    @ApiModelProperty("关联单明细Id")
    private Long relateDocDid;
}
