package com.elitesland.order.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author: ryan.xu
 * @since 2023/9/23
 */
@Data
@ApiModel("销转外采-采购订单关闭明细入参")
public class SalSoDCancelParamDTO implements Serializable {
    private static final long serialVersionUID = -5871153289242512045L;

    @ApiModelProperty("销售订单明细ID")
    private Long soDId;

    @ApiModelProperty("采购订单明细ID")
    private Long poDId;

    @ApiModelProperty("销售订单明细行号")
    private BigDecimal lineNo;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("取消的数量")
    private BigDecimal cancelQty;

}
