package com.elitesland.order.param;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class RetailOrderOdoSaveVO extends CustomFieldBaseModelVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主表ID")
    private Long masId;

    @ApiModelProperty("主表明细ID")
    private Long masDId;

    @ApiModelProperty("批次号")
    private String lotNo;

    @ApiModelProperty("生产日期")
    private LocalDateTime produceDate;

    @ApiModelProperty("有效期至")
    private LocalDateTime expiredDate;

    @ApiModelProperty("库存状态")
    private String limit1;

    @ApiModelProperty("生产厂家")
    private String manuFactory;

    @ApiModelProperty("生产厂家名称")
    private String manuFactoryName;

    @ApiModelProperty("批准文号")
    private String approvalNumber;

    @ApiModelProperty("仓库ID")
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whName;

    @ApiModelProperty("仓库名称")
    private String whCode;

    @ApiModelProperty("功能区编码")
    private String deter2;

    @ApiModelProperty("外部出入库单号")
    private String outerInvNo;

    @ApiModelProperty("外部行号")
    private BigDecimal outerLineNo;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("出入库数量（基本单位）")
    private BigDecimal outerInvQty;

    @ApiModelProperty("出入库数量日期")
    private LocalDateTime outerInvTime;

    @ApiModelProperty("零售价")
    private BigDecimal retailPrice;

    @ApiModelProperty("优惠价格")
    private BigDecimal discountPrice;

    @ApiModelProperty("实售价格")
    private BigDecimal price;

    @ApiModelProperty("商品零售金额")
    private BigDecimal goodsRetailAmt;

    @ApiModelProperty("优惠金额")
    private BigDecimal discountAmt;

    @ApiModelProperty("商品成交金额")
    private BigDecimal goodsTransactionAmt;

    @ApiModelProperty("商品未税金额")
    private BigDecimal goodsUntaxedAmt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("运费")
    private BigDecimal freightAmt;

    @ApiModelProperty("其它费用")
    private BigDecimal otherExpenses;

    @ApiModelProperty("应收金额")
    private BigDecimal arAmt;

    @ApiModelProperty("核销数量")
    private BigDecimal verQty;

    @ApiModelProperty("实收金额")
    private BigDecimal realRecAmt;

    @ApiModelProperty("买家实付")
    private BigDecimal buyerActualPaymentAmt;

    @ApiModelProperty("平台补贴")
    private BigDecimal platformSubsidyAmt;

    @ApiModelProperty("调整金额")
    private BigDecimal adjustmentAmt;

    @ApiModelProperty("买家实付调整")
    private BigDecimal buyerPaymentAdjustmentAmt;

    @ApiModelProperty("平台补贴调整")
    private BigDecimal platformSubsidyAdjustmentAmt;

    @ApiModelProperty("行类型 [UDC]SAL:SO_LINE_TYPE")
    private String lineType;

    @ApiModelProperty("行状态")
    private String lineStatus;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("商品编号")
    private String itemCode;

    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    private String relateDocCls;

    @ApiModelProperty("关联单据ID")
    private Long relateDocId;

    @ApiModelProperty("关联单据编号")
    private String relateDocNo;

    @ApiModelProperty("关联单据明细ID")
    private Long relateDocDid;

    @ApiModelProperty("关联单据行号")
    private BigDecimal relateDocLineno;

    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    private String relateDoc2Cls;

    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;

    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;

    @ApiModelProperty("关联单据2明细ID")
    private Long relateDoc2Did;

    @ApiModelProperty("关联单据2行号")
    private BigDecimal relateDoc2Lineno;

    @ApiModelProperty("关联单据3明细ID")
    private Long relateDoc3Did;

    @ApiModelProperty("关联单据3行号")
    private BigDecimal relateDoc3Lineno;

    @ApiModelProperty("关联单据3编号")
    private String relateDoc3No;

    @ApiModelProperty("关联单据3ID")
    private Long relateDoc3Id;

    @ApiModelProperty("关联单据3类别 [UDC]COM:DOC_CLS")
    private String relateDoc3Cls;
}