package com.elitesland.order.param;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class RetailOrderSaveVO extends CustomFieldBaseModelVo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("单据编号")
    private String docNo;

    @ApiModelProperty("外部系统类型 JST聚水潭 JKY吉客云 ...")
    private String externalType;
    @ApiModelProperty("外部系统唯一标识 更新用")
    private String externalId;

    @ApiModelProperty("BUID5")
    private Long buId5;

    @ApiModelProperty("单据类别")
    private String docCls;

    @ApiModelProperty("单据类型")
    private String docType;
    @ApiModelProperty("单据类型名称")
    private String docTypeName;

    @ApiModelProperty("退货原因")
    private String returnReason;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司编号")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    /**
     * 客户id
     */
    @ApiModelProperty("客户id")
    private Long custId;
    /**
     * 客户编号
     */
    @ApiModelProperty("客户编号")
    private String custCode;
    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("组织编号")
    private String buCode;

    @ApiModelProperty("组织名称")
    private String buName;

    @ApiModelProperty("BUID")
    private Long buId;

    @ApiModelProperty("BUID2")
    private Long buId2;

    @ApiModelProperty("BUID3")
    private Long buId3;

    @ApiModelProperty("BUID4")
    private Long buId4;

    @ApiModelProperty("门店ID")
    private Long storeId;

    @ApiModelProperty("门店编号")
    private String storeCode;

    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty("来源渠道")
    private String orderSource;

    @ApiModelProperty("来源渠道名称")
    private String orderSourceName;

    @ApiModelProperty("经营性质")
    private String storeType2;

    @ApiModelProperty("经营性质名称")
    private String storeType2Name;

    @ApiModelProperty("店长姓名")
    private String storeManager;

    @ApiModelProperty("门店电话")
    private String storeContPhone;

    @ApiModelProperty("渠道类型yst-supp:CHANNEL_TYPE")
    private String channelType;

    @ApiModelProperty("RETAIL_ABNORMAL_STATUS异常状态 0正常 1异常")
    private String abnormalStatus;

    @ApiModelProperty("是否已生成合并单默认否 0 否 1 是")
    private String mergeFlag;

    @ApiModelProperty("来源系统")
    private String sourceSystem;
    @ApiModelProperty("来源系统名称")
    private String sourceSystemName;

    @ApiModelProperty("记账日期")
    private LocalDateTime accountTime;

    @ApiModelProperty("业务日期")
    private LocalDateTime busTime;

    @ApiModelProperty("业务员员工ID")
    private Long agentEmpId;

    @ApiModelProperty("业务员员工名字")
    private String agentName;

    @ApiModelProperty("业务员编码")
    private String agentCode;

    @ApiModelProperty("会员编码")
    private String memberCode;

    @ApiModelProperty("会员名称")
    private String memberName;

    @ApiModelProperty("会员电话")
    private String memberPhone;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("币种名称")
    private String currName;

    @ApiModelProperty("单据状态 [UDC]SAL:SO_STATUS/RSO_STATUS")
    private String docStatus;

    @ApiModelProperty("付款状态")
    private String payStatus;

    @ApiModelProperty("扣库状态 RETAIL_STOCK_STATUS  0无需处理 1未扣库 2已锁库 3锁库失败 4已扣库 5未入库 6已入库 ")
    private String deductStockStatus;

    @ApiModelProperty("是否一件代发 0 否 1 是")
    private String suppFlag;

    @ApiModelProperty("对账状态")
    private String reconcileStatus;

    @ApiModelProperty("结算状态 0未结算  1已结算 RETAIL_SETTLE_STATUS")
    private String settleStatus;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("来源单号类别")
    private String relateDocCls;

    @ApiModelProperty("来源单号类型")
    private String relateDocType;

    @ApiModelProperty("来源单号id")
    private Long relateDocId;

    @ApiModelProperty("来源单号")
    private String relateDocNo;

    @ApiModelProperty("外部订单号")
    private String outerNo;

    @ApiModelProperty("平台单号")
    private String outerNo2;

    @ApiModelProperty("原订单号")
    private String docNo2;

    @ApiModelProperty("商品零售金额")
    private BigDecimal goodsRetailAmt;

    @ApiModelProperty("优惠金额")
    private BigDecimal discountAmt;

    @ApiModelProperty("商品成交金额")
    private BigDecimal goodsTransactionAmt;

    @ApiModelProperty("商品未税金额")
    private BigDecimal goodsUntaxedAmt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("运费")
    private BigDecimal freightAmt;

    @ApiModelProperty("其它费用")
    private BigDecimal otherExpenses;

    @ApiModelProperty("应收总额")
    private BigDecimal arAmt;

    @ApiModelProperty("实收总额")
    private BigDecimal realRecAmt;

    @ApiModelProperty("买家实付")
    private BigDecimal buyerActualPaymentAmt;

    @ApiModelProperty("平台补贴")
    private BigDecimal platformSubsidyAmt;

    @ApiModelProperty("调整金额")
    private BigDecimal adjustmentAmt;

    @ApiModelProperty("买家实付调整")
    private BigDecimal buyerPaymentAdjustmentAmt;

    @ApiModelProperty("平台补贴调整")
    private BigDecimal platformSubsidyAdjustmentAmt;

    @ApiModelProperty("明细")
    private List<RetailOrderDSaveVO> deteils;
}